


doors = {};

function doors.prerequisitesPresent(specializations)
    return true
end;

function doors:load(xmlFile)
-- door right
    local door_1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_1#index"));
    if door_1Node ~= nil then
        self.door_1 = {};
        self.door_1.node = door_1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_1#minRot"));
        self.door_1.minRot = {};
        self.door_1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door_1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -0.80379));
        self.door_1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_1#maxRot"));
        self.door_1.maxRot = {};
        self.door_1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, -7.40708));
        self.door_1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -45.04799));
        self.door_1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, -0.18841));

        self.door_1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_1#rotTime"), 2)*1000;
    end;

-- door left
    local door_2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_2#index"));
    if door_2Node ~= nil then
        self.door_2 = {};
        self.door_2.node = door_2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_2#minRot"));
        self.door_2.minRot = {};
        self.door_2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door_2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door_2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_2#maxRot"));
        self.door_2.maxRot = {};
        self.door_2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, -7.40708));
        self.door_2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 43.04799));
        self.door_2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0.18841));

        self.door_2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_2#rotTime"), 2)*1000;
     end;

--window front
local door_3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_3#index"));
    if door_3Node ~= nil then
        self.door_3 = {};
        self.door_3.node = door_3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_3#minRot"));
        self.door_3.minRot = {};
        self.door_3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0.60914));
        self.door_3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_3#maxRot"));
        self.door_3.maxRot = {};
        self.door_3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, -68.0319));
        self.door_3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.door_3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_3#rotTime"), 2)*1000;
    end;

-- window rear
local door_4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_4#index"));
    if door_4Node ~= nil then
        self.door_4 = {};
        self.door_4.node = door_4Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_4#minRot"));
        self.door_4.minRot = {};
        self.door_4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, -12.3092));
        self.door_4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_4#maxRot"));
        self.door_4.maxRot = {};
        self.door_4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 69.6104));
        self.door_4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.door_4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_4#rotTime"), 2)*1000;
     end;

--fernlicht
local door_5Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_5#index"));
    if door_5Node ~= nil then
        self.door_5 = {};
        self.door_5.node = door_5Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_5#minRot"));
        self.door_5.minRot = {};
        self.door_5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0.60914));
        self.door_5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_5#maxRot"));
        self.door_5.maxRot = {};
        self.door_5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, -68.0319));
        self.door_5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -0));
        self.door_5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.door_5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_5#rotTime"), 2)*1000;
    end;

--hydraulik
    local door_6Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door_6#index"));
    if door_6Node ~= nil then
        self.door_6= {};
        self.door_6.node = door_6Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_6#minRot"));
        self.door_6.minRot = {};
        self.door_6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door_6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -0.80379));
        self.door_6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.door_6#maxRot"));
        self.door_6.maxRot = {};
        self.door_6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, -7.40708));
        self.door_6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -45.04799));
        self.door_6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, -0.18841));

        self.door_6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.door_6#rotTime"), 2)*1000;
    end;
end;


function doors:delete()
end;

function doors:mouseEvent(posX, posY, isDown, isUp, button)
end;

function doors:keyEvent(unicode, sym, modifier, isDown)
end;

function doors:update(dt)
		if self.showHudInfoBase and self.isEntered and self.statisticsMode == 3 then
			self:addInfoText(InputBinding.DOORRIGHT, g_i18n:getText("door_1"));
		   self:addInfoText(InputBinding.DOORLEFT, g_i18n:getText("door_2"));
		   self:addInfoText(InputBinding.WINDOWFRONT, g_i18n:getText("door_3"));
		   self:addInfoText(InputBinding.WINDOWREAR, g_i18n:getText("door_4") );
		   self:addInfoText(InputBinding.FERNLICHT, g_i18n:getText("door_5") );
		   self:addInfoText(InputBinding.HYDRAULIK, g_i18n:getText("door_6") );
		end;
    if self:getIsActiveForInput() then   
		if InputBinding.hasEvent(InputBinding.DOORRIGHT) then
            self.door_1.rotation = not self.door_1.rotation;
        end;
		if InputBinding.hasEvent(InputBinding.DOORLEFT) then
            self.door_2.rotation = not self.door_2.rotation;
        end;
		if InputBinding.hasEvent(InputBinding.WINDOWFRONT) then
            self.door_3.rotation = not self.door_3.rotation;
        end;
		if InputBinding.hasEvent(InputBinding.WINDOWREAR) then
            self.door_4.rotation = not self.door_4.rotation;
        end;
		if InputBinding.hasEvent(InputBinding.FERNLICHT) then
            self.door_5.rotation = not self.door_5.rotation;
        end;
		if InputBinding.hasEvent(InputBinding.HYDRAULIK) then
            self.door_6.rotation = not self.door_6.rotation;
        end;
    end;	

-- door right
    if self.door_1 ~= nil then
        local x, y, z = getRotation(self.door_1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_1.maxRot, self.door_1.minRot, 3, self.door_1.rotTime, dt, not self.door_1.rotation);
        setRotation(self.door_1.node, unpack(newRot));
    end;


-- door left
    if self.door_2 ~= nil then
        local x, y, z = getRotation(self.door_2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_2.maxRot, self.door_2.minRot, 3, self.door_2.rotTime, dt, not self.door_2.rotation);
        setRotation(self.door_2.node, unpack(newRot));
    end;

-- window front
    if self.door_3 ~= nil then
        local x, y, z = getRotation(self.door_3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_3.maxRot, self.door_3.minRot, 3, self.door_3.rotTime, dt, not self.door_3.rotation);
        setRotation(self.door_3.node, unpack(newRot));
    end;

-- window rear
    if self.door_4 ~= nil then
        local x, y, z = getRotation(self.door_4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_4.maxRot, self.door_4.minRot, 3, self.door_4.rotTime, dt, not self.door_4.rotation);
        setRotation(self.door_4.node, unpack(newRot));
    end;

-- fernlicht
    if self.door_5 ~= nil then
        local x, y, z = getRotation(self.door_5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_5.maxRot, self.door_5.minRot, 3, self.door_5.rotTime, dt, not self.door_5.rotation);
        setRotation(self.door_5.node, unpack(newRot));
    end;

-- hydraulik
    if self.door_6 ~= nil then
        local x, y, z = getRotation(self.door_6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.door_6.maxRot, self.door_6.minRot, 3, self.door_6.rotTime, dt, not self.door_6.rotation);
        setRotation(self.door_6.node, unpack(newRot));
    end;
end;

function doors:draw()

end;
