--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

CaseIHMagnumShowHelp = {};

function CaseIHMagnumShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CaseIHMagnumShowHelp:load(xmlFile)
	self.CaseIHMagnumShowHelp = false;
end;

function CaseIHMagnumShowHelp:delete()
end;

function CaseIHMagnumShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CaseIHMagnumShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function CaseIHMagnumShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.CaseIHMagnumShowHelp = not self.CaseIHMagnumShowHelp;
		end;
	end;
end;



function CaseIHMagnumShowHelp:updateTick(dt)
end;


function CaseIHMagnumShowHelp:draw()
	if not self.CaseIHMagnumShowHelp then
		renderText(0.75, 0.25, 0.02, " Numpad 0: CaseIH Magnum Info ");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.75, 0.25, 0.02, "Numpad 0: Info Aus");
		renderText(0.72, 0.68, 0.025, "- CaseIH Magnum 335 -");			
		renderText(0.72, 0.65, 0.02, "Key Home: Rundumleuchten ");
		renderText(0.72, 0.63, 0.02, "Key KP 1: Blinker links ");
		renderText(0.72, 0.61, 0.02, "Key KP 2: Warnblinker");
		renderText(0.72, 0.59, 0.02, "Key KP 3: Blinker rechts");
		renderText(0.72, 0.57, 0.02, "Key KP 5: Arbeitslicht vorne ");
		renderText(0.72, 0.55, 0.02, "Key KP 6: Arbeitslicht hinten");
		renderText(0.72, 0.53, 0.02, "Key KP 7: Allrad");
		renderText(0.72, 0.50, 0.02, "Key KP Enter: Motor an/aus");
		renderText(0.72, 0.47, 0.02, "Key Page_Up: ESLimiter_PLUS");
		renderText(0.72, 0.45, 0.02, "Key Page_Down: ESLimiter_Minus");
		renderText(0.72, 0.43, 0.02, "Key 5: Zugmaul hoch");
		renderText(0.72, 0.41, 0.02, "Key 6: Zugmaul runter");
		renderText(0.72, 0.39, 0.02, "Key 7: Zwillingsreifen vorne");			
		renderText(0.72, 0.37, 0.02, "Key 8: Zwillingsreifen hinten ");
		renderText(0.72, 0.33, 0.02, "Key 0: Hupe");
	renderText(0.72, 0.28, 0.025, "- CaseIH Magnum 335 -");
	end;
end;

function CaseIHMagnumShowHelp:onLeave()
	self.CaseIHMagnumShowHelp = false;
end;




