--
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Budman81
-- Date 5/10/2012
-- 
--
-- Copyright (c) Budman81. - All Rights Reserved.
--

CaseShowHelp = {};

function CaseShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CaseShowHelp:load(xmlFile)
	self.CaseShowHelp = false;
end;

function CaseShowHelp:delete()
end;

function CaseShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CaseShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function CaseShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.CaseShowHelp = not self.CaseShowHelp;
		end;
	end;
end;



function CaseShowHelp:updateTick(dt)
end;


function CaseShowHelp:draw()
	if not self.CaseShowHelp then
		renderText(0.80, 0.25, 0.02, " Numpad 0: Case International 2594 Info  ");
	 else
		renderText(0.80, 0.25, 0.02, "Numpad 0: Case 2594 Info ");
		renderText(0.72, 0.68, 0.025, "- Case International 2594 -");			
		renderText(0.72, 0.65, 0.02, "Key Home: Rundumleuchten ");
		renderText(0.72, 0.63, 0.02, "Key KP 1: Blinker Left ");
		renderText(0.72, 0.61, 0.02, "Key KP 2: Warnblinker");
		renderText(0.72, 0.59, 0.02, "Key KP 3: Blinker Right");
		renderText(0.72, 0.57, 0.02, "Key F Main lights ");
		renderText(0.72, 0.55, 0.02, "Key KP 5: Front Worklights ");
		renderText(0.72, 0.53, 0.02, "Key KP 6: Back Worklights");			
		renderText(0.72, 0.51, 0.02, "Key KP 7: Left window");
		renderText(0.72, 0.49, 0.02, "Key KP 8: Back window ");
		renderText(0.72, 0.47, 0.02, "Key KP 9: Right window ");
		renderText(0.72, 0.43, 0.02, "Key 8: Dual Wheels ");
		renderText(0.72, 0.41, 0.02, "Key Page_Up: ESL Limiter ");
		renderText(0.72, 0.39, 0.02, "Key Page_Down: ESL Limiter ");
		renderText(0.72, 0.31, 0.02, "Key 0: Horn");
        renderText(0.72, 0.28, 0.025, "- Case International 2594 -");
	end;
end;

function CaseShowHelp:onLeave()
	self.CaseShowHelp = false;
end;




