stuetzen = {};

function stuetzen.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function stuetzen:load(xmlFile)
	self.isActor = false;
	self.setStuetze = SpecializationUtil.callSpecializationsFunction("setStuetze");
	local stu1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stu1#index"));
	if stu1 ~= nil then
		self.stu1 = {};
		self.stu1.node = stu1;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu1#minRot"));
		self.stu1.minRot = {};
		self.stu1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu1#maxRot"));
		self.stu1.maxRot = {};
		self.stu1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.stu1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stu1#rotTime"), 1)*1000;
		self.supportTrans1 = {};
		self.supportTrans1.node = stu1;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu1#minTrans"));
		self.supportTrans1.minRot = {};
		self.supportTrans1.minRot[1] = x;
		self.supportTrans1.minRot[2] = y;
		self.supportTrans1.minRot[3] = z;
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu1#maxTrans"));
		self.supportTrans1.maxRot = {};
		self.supportTrans1.maxRot[1] = x;
		self.supportTrans1.maxRot[2] = y;
		self.supportTrans1.maxRot[3] = z;
		self.supportTrans1.rotTime = self.stu1.rotTime;
	end;
	local stu2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stu2#index"));
	if stu2 ~= nil then
		self.stu2 = {};
		self.stu2.node = stu2;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu2#minRot"));
		self.stu2.minRot = {};
		self.stu2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu2#maxRot"));
		self.stu2.maxRot = {};
		self.stu2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.stu2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stu2#rotTime"), 1)*1000;
		self.supportTrans2 = {};
        self.supportTrans2.node = stu2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu2#minTrans"));
        self.supportTrans2.minRot = {};
        self.supportTrans2.minRot[1] = x;
        self.supportTrans2.minRot[2] = y;
        self.supportTrans2.minRot[3] = z;
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu2#maxTrans"));
        self.supportTrans2.maxRot = {};
        self.supportTrans2.maxRot[1] = x;
        self.supportTrans2.maxRot[2] = y;
        self.supportTrans2.maxRot[3] = z;
        self.supportTrans2.rotTime = self.stu2.rotTime;


	end;	
	local stu3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stu3#index"));
	if stu3 ~= nil then
		self.stu3 = {};
		self.stu3.node = stu3;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu3#minRot"));
		self.stu3.minRot = {};
		self.stu3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu3#maxRot"));
		self.stu3.maxRot = {};
		self.stu3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.stu3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stu3#rotTime"), 1)*1000;
		self.supportTrans3 = {};
        self.supportTrans3.node = stu3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu3#minTrans"));
        self.supportTrans3.minRot = {};
        self.supportTrans3.minRot[1] = x;
        self.supportTrans3.minRot[2] = y;
        self.supportTrans3.minRot[3] = z;
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu3#maxTrans"));
        self.supportTrans3.maxRot = {};
        self.supportTrans3.maxRot[1] = x;
        self.supportTrans3.maxRot[2] = y;
        self.supportTrans3.maxRot[3] = z;
        self.supportTrans3.rotTime = self.stu3.rotTime;
	end;	
	local stu4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stu4#index"));
	if stu4 ~= nil then
		self.stu4 = {};
		self.stu4.node = stu4;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu4#minRot"));
		self.stu4.minRot = {};
		self.stu4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu4#maxRot"));
		self.stu4.maxRot = {};
		self.stu4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.stu4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.stu4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.stu4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stu4#rotTime"), 1)*1000;
		self.supportTrans4 = {};
        self.supportTrans4.node = stu4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu4#minTrans"));
        self.supportTrans4.minRot = {};
        self.supportTrans4.minRot[1] = x;
        self.supportTrans4.minRot[2] = y;
        self.supportTrans4.minRot[3] = z;
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stu4#maxTrans"));
        self.supportTrans4.maxRot = {};
        self.supportTrans4.maxRot[1] = x;
        self.supportTrans4.maxRot[2] = y;
        self.supportTrans4.maxRot[3] = z;
        self.supportTrans4.rotTime = self.stu4.rotTime;
	end;	
	
	self.StuetzenAn = true;
end;



function stuetzen:keyEvent(unicode, sym, modifier, isDown)
end;

function stuetzen:update(dt)
		if InputBinding.hasEvent(InputBinding.KRANSTUETZEN) and self:getIsActiveForInput() then
			self.StuetzenAn = not self.StuetzenAn;
			stuetzenEvent.sendEvent(self, self.StuetzenAn);
		end;
end;

function stuetzen:updateTick(dt)
	if self.StuetzenAn ~= nil then	
		if self.StuetzenAn then
			local x, y, z = getTranslation(self.supportTrans1.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, true);
			setTranslation(self.supportTrans1.node, unpack(newTrans));
			if math.abs(self.supportTrans1.minRot[1]-newTrans[1]) < 0.001 then
				local x, y, z = getRotation(self.stu1.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.stu1.maxRot, self.stu1.minRot, 3, self.stu1.rotTime, dt, true);
				setRotation(self.stu1.node, unpack(newRot));
			end;
			local x2, y2, z2 = getTranslation(self.supportTrans2.node);
			local trans2 = {x2,y2,z2};
			local newTrans2 = Utils.getMovedLimitedValues(trans2, self.supportTrans2.maxRot, self.supportTrans2.minRot, 3, self.supportTrans2.rotTime, dt, true);
			setTranslation(self.supportTrans2.node, unpack(newTrans2));
			
			if math.abs(self.supportTrans2.minRot[1]-newTrans2[1]) < 0.001 then
				local x2, y2, z2 = getRotation(self.stu2.node);
				local rot2 = {x2,y2,z2};
				local newRot2 = Utils.getMovedLimitedValues(rot2, self.stu2.maxRot, self.stu2.minRot, 3, self.stu2.rotTime, dt, true);
				setRotation(self.stu2.node, unpack(newRot2));
			end;
			local x3, y3, z3 = getTranslation(self.supportTrans3.node);
			local trans3 = {x3,y3,z3};
			local newTrans3 = Utils.getMovedLimitedValues(trans3, self.supportTrans3.maxRot, self.supportTrans3.minRot, 3, self.supportTrans3.rotTime, dt, true);
			setTranslation(self.supportTrans3.node, unpack(newTrans3));
			if math.abs(self.supportTrans3.minRot[1]-newTrans3[1]) < 0.001 then
				local x3, y3, z3 = getRotation(self.stu3.node);
				local rot3 = {x3,y3,z3};
				local newRot3 = Utils.getMovedLimitedValues(rot3, self.stu3.maxRot, self.stu3.minRot, 3, self.stu3.rotTime, dt, self.StuetzenAn);
				setRotation(self.stu3.node, unpack(newRot3));
			end;
				local x4, y4, z4 = getTranslation(self.supportTrans4.node);
				local trans4 = {x4,y4,z4};
				local newTrans4 = Utils.getMovedLimitedValues(trans4, self.supportTrans4.maxRot, self.supportTrans4.minRot, 3, self.supportTrans4.rotTime, dt, true);
			setTranslation(self.supportTrans4.node, unpack(newTrans4));		
			if math.abs(self.supportTrans4.minRot[1]-newTrans4[1]) < 0.001 then
				local x4, y4, z4 = getRotation(self.stu4.node);
				local rot4 = {x4,y4,z4};
				local newRot4 = Utils.getMovedLimitedValues(rot4, self.stu4.maxRot, self.stu4.minRot, 3, self.stu4.rotTime, dt, true);
				setRotation(self.stu4.node, unpack(newRot4));
			end;				
		else
			local x, y, z = getRotation(self.stu1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.stu1.maxRot, self.stu1.minRot, 3, self.stu1.rotTime, dt, false);
			setRotation(self.stu1.node, unpack(newRot));
			if math.abs(self.stu1.maxRot[1]-newRot[1]) < 0.001 then
				local x, y, z = getTranslation(self.supportTrans1.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, false);
				setTranslation(self.supportTrans1.node, unpack(newTrans));
			end;
			
			local x2, y2, z2 = getRotation(self.stu2.node);
		local rot2 = {x2,y2,z2};
			local newRot2 = Utils.getMovedLimitedValues(rot2, self.stu2.maxRot, self.stu2.minRot, 3, self.stu2.rotTime, dt, false);
			setRotation(self.stu2.node, unpack(newRot2));
			if math.abs(self.stu2.maxRot[1]-newRot2[1]) < 0.001 then
				local x2, y2, z2 = getTranslation(self.supportTrans2.node);
				local trans2 = {x2,y2,z2};
				local newTrans2 = Utils.getMovedLimitedValues(trans2, self.supportTrans2.maxRot, self.supportTrans2.minRot, 3, self.supportTrans2.rotTime, dt, false);
				setTranslation(self.supportTrans2.node, unpack(newTrans2));
			end;
			local x3, y3, z3 = getRotation(self.stu3.node);
			local rot3 = {x3,y3,z3};
			local newRot3 = Utils.getMovedLimitedValues(rot3, self.stu3.maxRot, self.stu3.minRot, 3, self.stu3.rotTime, dt, false);
			setRotation(self.stu3.node, unpack(newRot3));
			if math.abs(self.stu3.maxRot[1]-newRot3[1]) < 0.001 then
				local x3, y3, z3 = getTranslation(self.supportTrans3.node);
				local trans3 = {x3,y3,z3};
				local newTrans3 = Utils.getMovedLimitedValues(trans3, self.supportTrans3.maxRot, self.supportTrans3.minRot, 3, self.supportTrans3.rotTime, dt, false);
				setTranslation(self.supportTrans3.node, unpack(newTrans3));
			end;
			local x4, y4, z4 = getRotation(self.stu4.node);
			local rot4 = {x4,y4,z4};
			local newRot4 = Utils.getMovedLimitedValues(rot4, self.stu4.maxRot, self.stu4.minRot, 3, self.stu4.rotTime, dt, false);
			setRotation(self.stu4.node, unpack(newRot4));
			if math.abs(self.stu4.maxRot[1]-newRot4[1]) < 0.001 then
				local x4, y4, z4 = getTranslation(self.supportTrans4.node);
				local trans4 = {x4,y4,z4};
				local newTrans4 = Utils.getMovedLimitedValues(trans4, self.supportTrans4.maxRot, self.supportTrans4.minRot, 3, self.supportTrans4.rotTime, dt, false);
				setTranslation(self.supportTrans4.node, unpack(newTrans4));
			end;	
		end;
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;

function stuetzen:draw()
	if self.StuetzenAn then
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.KRANSTUETZEN))..":                      " .." Kranstuetzen");
	else
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.KRANSTUETZEN))..":                      " .." Kranstuetzen");
	end;
end;
function stuetzen:readStream(streamId, connection)
	self.StuetzenAn = streamReadBool(streamId);
end;

function stuetzen:writeStream(streamId, connection)
	streamWriteBool(streamId, self.StuetzenAn);
end;
function stuetzen:mouseEvent(posX, posY, isDown, isUp, button)
end;

function stuetzen:delete()
end;

function stuetzen:onDetach()
	if not self.StuetzenAn then
		self.StuetzenAn = not self.StuetzenAn;
		stuetzenEvent.sendEvent(self, self.StuetzenAn);
	end;
end;