--
-- TowBall
-- Specialization for TowBall functionality
--
-- Modschmiede / LS-Modsource
-- @author  Manuel Leithner
-- @date  25/12/09
--

TowBall = {};

function TowBall.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function TowBall:load(xmlFile)

	local towBall = getXMLString(xmlFile, "vehicle.towBall#file");
	if towBall ~= nil then
		towBall = Utils.getFilename(towBall, self.baseDirectory);
		self.towBall = towBall;
	else
		print("No towBall path available");
	end;	

	self.attacherJointString = getXMLString(xmlFile, "vehicle.towBall#attacherPoint");
	self.leftFixPointString = getXMLString(xmlFile, "vehicle.towBall#leftFixPoint");
	self.rightFixPointString = getXMLString(xmlFile, "vehicle.towBall#rightFixPoint");	
	
	self.attacherPoint = nil;
	self.leftFixPoint = nil;
	self.rightFixPoint = nil;
	self.loadedTowBall = nil;
	
	self.vehicleJoint = nil;
	self.TowBallAT = nil;
	self.jointSearch = false;
end;

function TowBall:delete()
end;

function TowBall:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TowBall:keyEvent(unicode, sym, modifier, isDown)
end;

function TowBall:update(dt)		
	
	if self.jointSearch then
		for i = 1, table.getn(self.attacherVehicle.attacherJoints) do
			j = self.attacherVehicle.attacherJoints[i];
			--print(j.jointType);
			--print(Vehicle.jointTypeNameToInt["TowBall"] );
			--print(Vehicle.JOINTTYPE_TOWBALL);
			if j.jointType == Vehicle.JOINTTYPE_TOWBALL then
				self.TowBallAT = j.jointTransform;
				--print(j.jointType);
			end;
		end;
		for i,v in pairs(self.attacherVehicle.attachedImplements) do
			if v.object == self then
				local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
				self.vehicleJoint = joint;	
				--print(joint.jointType);
					-- load,link i3d-File
					local i3dTowBall = loadI3DFile(self.towBall);
					i3dTowBall = getChildAt(i3dTowBall,0);
					if i3dTowBall ~= 0 then
						self.attacherPoint = Utils.indexToObject(i3dTowBall, self.attacherJointString);
						self.leftFixPoint = Utils.indexToObject(i3dTowBall, self.leftFixPointString);
						self.rightFixPoint = Utils.indexToObject(i3dTowBall, self.rightFixPointString);				
						self.loadedTowBall = i3dTowBall;
						if self.TowBallAT == nil then
							link(joint.jointTransform, i3dTowBall);
							setVisibility(i3dTowBall, true);
						else
							link(self.TowBallAT, i3dTowBall);
							setVisibility(i3dTowBall, false);
						end;
					end;	
					if self.TowBallAT == nil then
						setJointFrame(joint.jointIndex, 0, self.attacherPoint);
					else
						setJointFrame(joint.jointIndex, 0, self.TowBallAT);
					end;					
					
			end;
		end;
		self.jointSearch = false;
	end;	
end;

function TowBall:draw()
end;


function TowBall:onAttach(attacherVehicle)
	self.jointSearch = true;
end;

function TowBall:onDetach()	

	if self.loadedTowBall ~= nil then

		unlink(self.loadedTowBall);
		delete(self.loadedTowBall);
		self.TowBallAT = nil;
		self.attacherPoint = nil;
		self.leftFixPoint = nil;
		self.rightFixPoint = nil;				
		self.loadedTowBall = nil;
	end;
	self.vehicleJoint = nil;
end;
