--
-- Supportbar
-- Specialization for Supportbar functionality
--
-- Modschmiede / LS-Modsource
-- @author  Manuel Leithner
-- @date  20/09/09
--

Supportbar = {};

function Supportbar.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Supportbar:load(xmlFile)
	
	self.supportbar = {};
	self.supportbar.jointIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.supportbar#jointIndex"), 0);
	
	if self.supportbar.jointIndex < 0 or self.supportbar.jointIndex > table.getn(self.componentJoints) then
		self.supportbar.jointIndex = 0;
		print("Supportbar-Error: Illegal joint index!");
	end;
	
	self.supportbar.translationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportbar#translationNode"));	
	self.supportbar.rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportbar#rotationNode"));
	
	if self.supportbar.translationNode ~= nil or self.supportbar.rotationNode ~= nil then
		if self.supportbar.translationNode ~= nil then
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.supportbar#minTrans"));
			self.supportbar.minTrans = {};
			self.supportbar.minTrans[1] = Utils.getNoNil(x, 0);
			self.supportbar.minTrans[2] = Utils.getNoNil(y, 0);
			self.supportbar.minTrans[3] = Utils.getNoNil(z, 0);
			x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.supportbar#maxTrans"));
			self.supportbar.maxTrans = {};
			self.supportbar.maxTrans[1] = Utils.getNoNil(x, 0);
			self.supportbar.maxTrans[2] = Utils.getNoNil(y, 0);
			self.supportbar.maxTrans[3] = Utils.getNoNil(z, 0);	
			self.supportbar.transTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.supportbar#transTime"), 1) * 1000;	
		else
			self.supportbar.translationNode = self.supportbar.rotationNode;
			local x,y,z = getTranslation(self.supportbar.translationNode);
			self.supportbar.maxTrans = {};
			self.supportbar.maxTrans[1] = Utils.getNoNil(x, 0);
			self.supportbar.maxTrans[2] = Utils.getNoNil(y, 0);
			self.supportbar.maxTrans[3] = Utils.getNoNil(z, 0);
			self.supportbar.minTrans = {};
			self.supportbar.minTrans[1] = Utils.getNoNil(x, 0);
			self.supportbar.minTrans[2] = Utils.getNoNil(y, 0);
			self.supportbar.minTrans[3] = Utils.getNoNil(z, 0);
			self.supportbar.transTime = 1;
		end;
		
		if self.supportbar.rotationNode ~= nil then
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.supportbar#minRot"));
			self.supportbar.minRot = {};
			self.supportbar.minRot[1] = math.rad(Utils.getNoNil(x, 0));
			self.supportbar.minRot[2] = math.rad(Utils.getNoNil(y, 0));
			self.supportbar.minRot[3] = math.rad(Utils.getNoNil(z, 0));	
			x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.supportbar#maxRot"));
			self.supportbar.maxRot = {};
			self.supportbar.maxRot[1] = math.rad(Utils.getNoNil(x, 0));
			self.supportbar.maxRot[2] = math.rad(Utils.getNoNil(y, 0));
			self.supportbar.maxRot[3] = math.rad(Utils.getNoNil(z, 0));		
			self.supportbar.rotTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.supportbar#rotTime"), 1) * 1000;
		else
			self.supportbar.rotationNode = self.supportbar.translationNode;
			local x,y,z = getRotation(self.supportbar.rotationNode);
			self.supportbar.maxRot = {};
			self.supportbar.maxRot[1] = Utils.getNoNil(x, 0);
			self.supportbar.maxRot[2] = Utils.getNoNil(y, 0);
			self.supportbar.maxRot[3] = Utils.getNoNil(z, 0);
			self.supportbar.minRot = {};
			self.supportbar.minRot[1] = Utils.getNoNil(x, 0);
			self.supportbar.minRot[2] = Utils.getNoNil(y, 0);
			self.supportbar.minRot[3] = Utils.getNoNil(z, 0);
			self.supportbar.rotTime = 1;
		end;
	else
		print("Supportbar-Error: Translation or rotation node missing!");
	end;

	self.supportbar.isExpanded = true;
	self.supportbar.isActionFinished = true;
	self.renewCollision = false;
	self.runOnce = true;
end;

function Supportbar:delete()
end;

function Supportbar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Supportbar:keyEvent(unicode, sym, modifier, isDown)
end;

function Supportbar:update(dt)		
	
	if not self.supportbar.isActionFinished then	
		if self.supportbar.rotationNode ~= nil then
			self.renewCollision = false;
			local x, y, z = getRotation(self.supportbar.rotationNode);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.supportbar.maxRot, self.supportbar.minRot, 3, self.supportbar.rotTime, dt, self.supportbar.isExpanded);
			setRotation(self.supportbar.rotationNode, unpack(newRot));
			
			x, y, z = getTranslation(self.supportbar.translationNode);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.supportbar.maxTrans, self.supportbar.minTrans, 3, self.supportbar.transTime, dt, self.supportbar.isExpanded);
			setTranslation(self.supportbar.translationNode, unpack(newTrans));				
			for i=1, 3 do
				if math.abs(newTrans[i] - trans[i]) > 0.001 or math.abs(newRot[i] - rot[i]) > 0.001 then
					self.renewCollision = true;
					break;
				end;
			end;				

			self.supportbar.isActionFinished = true;
			local x,y,z = getRotation(self.supportbar.rotationNode);
			local rot = {x,y,z};
			x,y,z = getTranslation(self.supportbar.translationNode);
			local trans = {x,y,z};
			local finishTrans = self.supportbar.minTrans;
			local finishRot = self.supportbar.minRot;
			if not self.supportbar.isExpanded then
				finishTrans = self.supportbar.maxTrans;
				finishRot = self.supportbar.maxRot;		
			end;
			if self.supportbar.jointIndex > 0 and (self.renewCollision or self.runOnce) then
				local index = self.supportbar.jointIndex;			
				setJointFrame(self.componentJoints[index].jointIndex, 0, self.componentJoints[index].jointNode);
				self.runOnce = false;
			end;
			
			for i=1, 3 do
				if math.abs(finishTrans[i] - trans[i]) > 0.001 or math.abs(finishRot[i] - rot[i]) > 0.001 then
					self.supportbar.isActionFinished = false;
					break;
				end;
			end;	
		end;
	end;
end;

function Supportbar:draw()
end;

function Supportbar:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		self.supportbar.isExpanded = Utils.getNoNil(getXMLBool(xmlFile, key.."#isSupportbarDown"),true);
		if self.supportbar.isExpanded then
			setTranslation(self.supportbar.translationNode, unpack(self.supportbar.minTrans));
			setRotation(self.supportbar.rotationNode, unpack(self.supportbar.minRot));
			self.runOnce = true;
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Supportbar:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isSupportbarDown="'..tostring(self.supportbar.isExpanded)..'"';
	return attributes, nil;
end;


function Supportbar:onAttach(attacherVehicle)
	self.supportbar.isExpanded = true;
	self.supportbar.isActionFinished = false;
end;

function Supportbar:onDetach()
	self.supportbar.isExpanded = false;
	self.supportbar.isActionFinished = false;
end;





