--
-- Tiger Crane Script
--
-- by Zippo


TigerCrane = {}

function TigerCrane.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TigerCrane:load(xmlFile) 

        local translationHyd1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationHyd1#index"));
        if translationHyd1Node ~= nil then
        self.translationHyd1 = {};
        self.translationHyd1.node = translationHyd1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd1#minTrans"));
        self.translationHyd1.minTrans = {};
        self.translationHyd1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd1#maxTrans"));
        self.translationHyd1.maxTrans = {};
        self.translationHyd1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationHyd1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd1#transTime"), 2)*1000;
        self.translationHyd1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd1#touchTransLimit"), 10);
    end;       
	
        local translationHyd2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationHyd2#index"));
        if translationHyd2Node ~= nil then
        self.translationHyd2 = {};
        self.translationHyd2.node = translationHyd2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd2#minTrans"));
        self.translationHyd2.minTrans = {};
        self.translationHyd2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd2#maxTrans"));
        self.translationHyd2.maxTrans = {};
        self.translationHyd2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationHyd2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd2#transTime"), 2)*1000;
        self.translationHyd2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd2#touchTransLimit"), 10);
    end;
    
    local translationHyd3Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationHyd3#index"));
        if translationHyd3Node ~= nil then
        self.translationHyd3 = {};
        self.translationHyd3.node = translationHyd3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd3#minTrans"));
        self.translationHyd3.minTrans = {};
        self.translationHyd3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationHyd3#maxTrans"));
        self.translationHyd3.maxTrans = {};
        self.translationHyd3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationHyd3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationHyd3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationHyd3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd3#transTime"), 2)*1000;
        self.translationHyd3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationHyd3#touchTransLimit"), 10);
    end;
    
    local translationExtNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationExt#index"));
        if translationExtNode ~= nil then
        self.translationExt = {};
        self.translationExt.node = translationExtNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationExt#minTrans"));
        self.translationExt.minTrans = {};
        self.translationExt.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationExt.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationExt.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationExt#maxTrans"));
        self.translationExt.maxTrans = {};
        self.translationExt.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationExt.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationExt.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationExt.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationExt#transTime"), 2)*1000;
        self.translationExt.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationExt#touchTransLimit"), 10);
    end; 
 
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
    
    local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;

        local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;
 
         local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
        self.rotation5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#touchRotLimit"), 10));
    end;
end;
      
function TigerCrane:delete()    
end;

function TigerCrane:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function TigerCrane:keyEvent(unicode, sym, modifier, isDown)

  if sym == Input.KEY_KP_4 then
		self.rotation1Max = isDown;
		self.rotation2Max = isDown;
		self.translationHyd2Max = isDown;
	end;
	if sym == Input.KEY_KP_7 then
		self.rotation1Min = isDown;
		self.rotation2Min = isDown;
		self.translationHyd2Min = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.rotation3Max = isDown;
		self.rotation4Max = isDown;
		self.translationHyd1Max = isDown;
	end;
	if sym == Input.KEY_KP_5 then
		self.rotation3Min = isDown;
		self.rotation4Min = isDown;
		self.translationHyd1Min = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.translationExtMax = isDown;
		self.translationHyd3Max = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationExtMin = isDown;
		self.translationHyd3Min = isDown;
	end;
	if sym == Input.KEY_KP_2 then
		self.rotation5Max = isDown;
	end;
	if sym == Input.KEY_KP_0 then
		self.rotation5Min = isDown;
	end;

end;

function TigerCrane:update(dt)

	local doTranslate = self.translationHyd1Max or self.translationHyd1Min 
	if self.translationHyd1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationHyd1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationHyd1.maxTrans, self.translationHyd1.minTrans, 3, self.translationHyd1.transTime, dt, not self.translationHyd1Max); 
		setTranslation(self.translationHyd1.node, unpack(newTrans)); 
	end;
	
	local doTranslate = self.translationHyd2Max or self.translationHyd2Min 
	if self.translationHyd2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationHyd2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationHyd2.maxTrans, self.translationHyd2.minTrans, 3, self.translationHyd2.transTime, dt, not self.translationHyd2Max); 
		setTranslation(self.translationHyd2.node, unpack(newTrans)); 
	end;
	
	local doTranslate = self.translationHyd3Max or self.translationHyd3Min 
	if self.translationHyd3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationHyd3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationHyd3.maxTrans, self.translationHyd3.minTrans, 3, self.translationHyd3.transTime, dt, not self.translationHyd3Max); 
		setTranslation(self.translationHyd3.node, unpack(newTrans)); 
	end;
	
	local doTranslate = self.translationExtMax or self.translationExtMin 
	if self.translationExt ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationExt.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationExt.maxTrans, self.translationExt.minTrans, 3, self.translationExt.transTime, dt, not self.translationExtMax); 
		setTranslation(self.translationExt.node, unpack(newTrans)); 
	end;

	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
    local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
        local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
        end;
	
	   local doRotate = self.rotation5Max or self.rotation5Min 
	if self.rotation5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
        end;
end;

function TigerCrane:draw()
end;

function TigerCrane:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
