--
-- Rotation 82
--
-- Specialization for New Rotation 82 mod
--
-- @author  Sebastian B. (Blancker, www.landwirtschaftssimulator-2009.de)
--
-- @date  14/11/09
--
-- Copyright By www.landwirtschaftssimulator-2009.de, All Rights Reserved.

Rotation = {};

function Rotation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Rotation:load(xmlFile)
    
	-- Anfang Linke Tr
	
	local rotationPartNodeLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Links#index"));
    if rotationPartNodeLinks ~= nil then
        self.rotationPartLinks = {};
        self.rotationPartLinks.node = rotationPartNodeLinks;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLinks#minRot"));
        self.rotationPartLinks.minRot = {};
        self.rotationPartLinks.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLinks.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLinks.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Links#maxRot"));
        self.rotationPartLinks.maxRot = {};
        self.rotationPartLinks.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLinks.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLinks.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLinks.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Links#rotTime"), 2)*1000;
        self.rotationPartLinks.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Links#touchRotLimit"), 10));
    end;
	
	-- Ende Linke Tr
	
	-- Anfang Rechte Tr
	
	local rotationPartNodeRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rechts#index"));
    if rotationPartNodeRechts ~= nil then
        self.rotationPartRechts = {};
        self.rotationPartRechts.node = rotationPartNodeRechts;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRechts#minRot"));
        self.rotationPartRechts.minRot = {};
        self.rotationPartRechts.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRechts.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRechts.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rechts#maxRot"));
        self.rotationPartRechts.maxRot = {};
        self.rotationPartRechts.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRechts.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRechts.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRechts.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rechts#rotTime"), 2)*1000;
        self.rotationPartRechts.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rechts#touchRotLimit"), 10));
    end;
	
	-- Ende Rechte Tr
	
	-- Anfang Heckfenster
	
	local rotationPartNodeHinten = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Hinten#index"));
    if rotationPartNodeHinten ~= nil then
        self.rotationPartHinten = {};
        self.rotationPartHinten.node = rotationPartNodeHinten;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartHinten#minRot"));
        self.rotationPartHinten.minRot = {};
        self.rotationPartHinten.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHinten.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHinten.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Hinten#maxRot"));
        self.rotationPartHinten.maxRot = {};
        self.rotationPartHinten.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartHinten.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartHinten.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartHinten.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Hinten#rotTime"), 2)*1000;
        self.rotationPartHinten.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Hinten#touchRotLimit"), 10));
    end;
	
	-- Ende Heckfenster
	
	-- Anfang Linkes Seitenfenster
	
	local rotationPartNodeLinksF = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LinksF#index"));
    if rotationPartNodeLinksF ~= nil then
        self.rotationPartLinksF = {};
        self.rotationPartLinksF.node = rotationPartNodeLinksF;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLinksF#minRot"));
        self.rotationPartLinksF.minRot = {};
        self.rotationPartLinksF.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLinksF.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLinksF.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.LinksF#maxRot"));
        self.rotationPartLinksF.maxRot = {};
        self.rotationPartLinksF.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLinksF.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLinksF.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLinksF.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.LinksF#rotTime"), 2)*1000;
        self.rotationPartLinksF.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.LinksF#touchRotLimit"), 10));
    end;
	
	-- Ende Linkes Seitenfenster
	
	-- Anfang Rechtes Seitenfenster
	
	local rotationPartNodeRechtsF = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.RechtsF#index"));
    if rotationPartNodeRechtsF ~= nil then
        self.rotationPartRechtsF = {};
        self.rotationPartRechtsF.node = rotationPartNodeRechtsF;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRechts#minRot"));
        self.rotationPartRechtsF.minRot = {};
        self.rotationPartRechtsF.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRechtsF.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRechtsF.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RechtsF#maxRot"));
        self.rotationPartRechtsF.maxRot = {};
        self.rotationPartRechtsF.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRechtsF.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRechtsF.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRechtsF.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.RechtsF#rotTime"), 2)*1000;
        self.rotationPartRechtsF.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.RechtsF#touchRotLimit"), 10));
    end;
	
	-- Ende Rechtes Seitenfenster
	
	-- Anfang Dachlucke
	
	local rotationPartNodeDach = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Dach#index"));
    if rotationPartNodeDach ~= nil then
        self.rotationPartDach = {};
        self.rotationPartDach.node = rotationPartNodeDach;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDach#minRot"));
        self.rotationPartDach.minRot = {};
        self.rotationPartDach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Dach#maxRot"));
        self.rotationPartDach.maxRot = {};
        self.rotationPartDach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Dach#rotTime"), 2)*1000;
        self.rotationPartDach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Dach#touchRotLimit"), 10));
    end;
	
	-- Ende Dachlucke
	
	-- Anfang Motorhaube
	
	local rotationPartNodeMotor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Motor#index"));
    if rotationPartNodeMotor ~= nil then
        self.rotationPartMotor = {};
        self.rotationPartMotor.node = rotationPartNodeMotor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMotor#minRot"));
        self.rotationPartMotor.minRot = {};
        self.rotationPartMotor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMotor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMotor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Motor#maxRot"));
        self.rotationPartMotor.maxRot = {};
        self.rotationPartMotor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMotor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMotor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMotor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Motor#rotTime"), 2)*1000;
        self.rotationPartMotor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Motor#touchRotLimit"), 10));
    end;
	
	-- Ende Motorhaube
	
	-- Anfang Bewegbare Arbeitslichter
	
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
	
	local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;
	
	local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;
	
	-- Anfang Bewegbare Arbeitslichter
	
	-- Anfang Twins
	
	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;
	
	self.twinWheelsActive= false;
	
	-- Ende Twins
	
	-- Anfang Particle
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	-- Ende Particle
	
	-- Blinker Anfang
	
	turn1SoundFile = Utils.getFilename("Model/sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("Model/sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	
	
	-- Blinker Ende
		
	-- Bremslich Anfang
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	-- Bremslich Ende
	
	-- Arbeitslicht Anfang
	
	self.arbeits_lights = {};
    self.arbeits_lights.far = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.arbeits_lights.far#index"));
    self.arbeitslightActive = false;
	
	-- Arbeitslicht Ende
	
end;

function Rotation:delete()
end;

function Rotation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rotation:keyEvent(unicode, sym, modifier, isDown)

	-- Anfang Linke Tr
	
	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxLinks = not self.rotationMaxLinks;
	end;
	
	-- Ende Linke Tr
	
	-- Anfang Rechte Tr
	
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxRechts = not self.rotationMaxRechts;
	end;
	
	-- Ende Rechte Tr
	
	-- Anfang Heckfenster
	
	if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxHinten = not self.rotationMaxHinten;
	end;
	
	-- Ende Heckfenster
	
	-- Anfang Linkes Seitenfenster
	
	if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxLinksF = not self.rotationMaxLinksF;
	end;
	
	-- Ende Linkes Seitenfenster
	
	-- Anfang Rechtes Seitenfenster
	
	if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxRechtsF = not self.rotationMaxRechtsF;
	end;
	
	-- Ende Rechtes Seitenfenster
	
	-- Anfang Dachlucke
	
	if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxDach = not self.rotationMaxDach;
	end;
	
	-- Ende Dachlucke
	
	-- Anfang Motorhaube
	
	if isDown and sym == Input.KEY_5 then 
		self.rotationMaxMotor = not self.rotationMaxMotor;
	end;
	
	-- Ende Motorhaube
	
	-- Anfang Bewegbare Arbeitslichter
	
	if sym == Input.KEY_6 then
		self.rotation1Max = isDown;
		self.rotation2Min = isDown; -- Links
	end;
	
	if sym == Input.KEY_7 then
		self.rotation1Min = isDown;
		self.rotation2Max = isDown; -- Rechts
	end;
	
	if sym == Input.KEY_8 then
		self.rotation3Min = isDown;
		self.rotation4Min = isDown; -- Unten
	end;
	
	if sym == Input.KEY_9 then
		self.rotation3Max = isDown;
		self.rotation4Max = isDown; -- Hoch
	end;
	
	-- Ende Bewegbare Arbeitslichter
	
	-- Anfang Twins

	if isDown and sym == Input.KEY_4 then 
		self.twinWheelsActive = not self.twinWheelsActive;
	end;
	
	-- Ende Twins
	
	--#########################--
	--#Blinker All Starts Hier#--
	--#########################--
	
	-- Blinker Rechts Anfang
	
	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_3 then 
			self.flashLeft = not self.flashLeft;
			self.delayOnLeft = 10;
			self.flashRight = false;
			self.flash = false;
			self.flashlightsRightActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsRight2Active = false;
			self.turnlightsActive2 = false;
			self.flashWarner = false;
		end;
	end;
	
	-- Blinker Rechts Ende
	
	-- Warnblinker Anfang
	
	if isDown and sym == Input.KEY_KP_2 then 
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	
	-- Warnblinker Ende
	
	-- Blinker Links Anfang
	
	if self.isMotorStarted then
		if isDown and sym == Input.KEY_KP_1 then 
			self.flashRight = not self.flashRight;
			self.delayOnRight = 10;
			self.flashLeft = false;
			self.flash = false;
			self.flashlightsLeftActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsLeft2Active = false;
			self.turnlightsActive = false;
			self.flashWarner = false;
		end;
	end;
	
	-- Blinker Links Ende
	
	--#######################--
	--#Blinker All Ends Hier#--
	--#######################--
	
	-- Arbeitslicht Anfang 
	
	if isDown and sym == Input.KEY_l then 
		self.fararbeitslightActive = not self.fararbeitslightActive;
		setVisibility(self.arbeits_lights.far, self.fararbeitslightActive);
	end;
	
	-- Arbeitslicht Ende
	
	-- Anfang Info Panel 
	
	if isDown and sym == Input.KEY_0 then
        self.helpPanel = not self.helpPanel;
    end;
	
	-- Ende Info Panel
	
end;

function Rotation:update(dt)
    
	-- Anfang Linke Tr
	
	if self.rotationPartLinks ~= nil then
		local x, y, z = getRotation(self.rotationPartLinks.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLinks.maxRot, self.rotationPartLinks.minRot, 3, self.rotationPartLinks.rotTime, dt, not self.rotationMaxLinks);
		setRotation(self.rotationPartLinks.node, unpack(newRot));
	end;
	
	-- Ende Linke Tr
	
	-- Anfang Rechte Tr
	
	if self.rotationPartRechts ~= nil then
		local x, y, z = getRotation(self.rotationPartRechts.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRechts.maxRot, self.rotationPartRechts.minRot, 3, self.rotationPartRechts.rotTime, dt, not self.rotationMaxRechts);
		setRotation(self.rotationPartRechts.node, unpack(newRot));
	end;
	
	-- Ende Rechte Tr
	
	-- Anfang Heckfenster
	
	if self.rotationPartHinten ~= nil then
		local x, y, z = getRotation(self.rotationPartHinten.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartHinten.maxRot, self.rotationPartHinten.minRot, 3, self.rotationPartHinten.rotTime, dt, not self.rotationMaxHinten);
		setRotation(self.rotationPartHinten.node, unpack(newRot));
	end;
	
	-- Ende Heckfenster
	
	-- Anfang Linkes Seitenfenster
	
	if self.rotationPartLinksF ~= nil then
		local x, y, z = getRotation(self.rotationPartLinksF.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLinksF.maxRot, self.rotationPartLinksF.minRot, 3, self.rotationPartLinksF.rotTime, dt, not self.rotationMaxLinksF);
		setRotation(self.rotationPartLinksF.node, unpack(newRot));
	end;
	
	-- Ende Linkes Seitenfenster
	
	-- Anfang Rechtes Seitenfenster
	
	if self.rotationPartRechtsF ~= nil then
		local x, y, z = getRotation(self.rotationPartRechtsF.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRechtsF.maxRot, self.rotationPartRechtsF.minRot, 3, self.rotationPartRechtsF.rotTime, dt, not self.rotationMaxRechtsF);
		setRotation(self.rotationPartRechtsF.node, unpack(newRot));
	end;
	
	-- Ende Rechtes Seitenfenster
	
	-- Anfang Dachlucke
	
	if self.rotationPartDach ~= nil then
		local x, y, z = getRotation(self.rotationPartDach.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDach.maxRot, self.rotationPartDach.minRot, 3, self.rotationPartDach.rotTime, dt, not self.rotationMaxDach);
		setRotation(self.rotationPartDach.node, unpack(newRot));
	end;
	
	-- Ende Dachlucke
	
	-- Anfang Motorhaube
	
	if self.rotationPartMotor ~= nil then
		local x, y, z = getRotation(self.rotationPartMotor.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMotor.maxRot, self.rotationPartMotor.minRot, 3, self.rotationPartMotor.rotTime, dt, not self.rotationMaxMotor);
		setRotation(self.rotationPartMotor.node, unpack(newRot));
	end;
	
	-- Ende Motorhaube
	
	-- Anfang Bewegbare Arbeitslichter
	
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation1.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation2.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation3.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x1r, y1r, z1r = getRotation(self.rotation4.node);
        local rot = {x1r,y1r,z1r};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	
	-- Ende Bewegbare Arbeitslichter
	
	-- Anfang Twins
	
	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;
	
	-- Ende Twins

	-- Anfang Particle
	
	if self.isEntered and Input.isKeyPressed(Input.KEY_w) then
		Utils.setEmittingState(self.dustParticleSystems, true);
	else
		Utils.setEmittingState(self.dustParticleSystems, false);
	end;
	
	-- Ende Particle
	
	--#########################--
	--#Blinker All Starts Hier#--
	--#########################--
	
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.turnlightsActive2 = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.turnlightsActive2 = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive2 = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;
		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
	--#######################--
	--#Blinker All Ends Hier#--
	--#######################--
	
	-- Bremslichter Anfang
	
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;	
	end;
	
	-- Bremslichter Ende
	
end;

function Rotation:onLeave()
	
	-- Arbeitslicht Anfang
	
	self.fararbeitsActive = false;
	
	-- Arbeitslichter Ende

end;

function Rotation:onEnter()
end;

function Rotation:draw()
		
	-- Anfang Info Panel
		
		if not self.helpPanel then
            renderText(0.8335, 0.15, 0.021, "Taste 0: Info ein");
        else
            renderText(0.8335, 0.15, 0.021, "Taste 0: Info aus");
        end;
        
        if self.helpPanel then
            renderText(0.80, 0.20, 0.02, "- Challenger Info -");
            renderText(0.78, 0.22, 0.02, "Numpad 1: Blinker Links");
			renderText(0.78, 0.24, 0.02, "Numpad 2: Warnblinker");
			renderText(0.78, 0.26, 0.02, "Numpad 3: Blinker Rechts");
			renderText(0.78, 0.28, 0.02, "Numpad 7: Linke Tr Auf/Zu ");
			renderText(0.78, 0.30, 0.02, "Numpad 9: Rechte Tr Auf/Zu");
			renderText(0.78, 0.32, 0.02, "Numpad 8: Heckscheibe Auf/Zu");
			renderText(0.78, 0.34, 0.02, "Taste L: Arbeitslichter An/Aus");
			renderText(0.78, 0.36, 0.02, "Taste T: Tanks An/Aus");
		end;

		--Ende Info Panel
	
end;