--
-- Shield Movement Script
--
-- by Zippo
-- 


Shield = {}

function Shield.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Shield:load(xmlFile)
	
	local rotationNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#rotTime"), 2)*1000;
        self.rotation7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#touchRotLimit"), 10));
    end;

hydra7SoundFile = Utils.getFilename("$data/vehicles/steerable/deutz/hydraulicUp.wav", self.baseDirectory);
    self.hydra7SoundId = createSample("HYDRotB_hydraRotB");
    loadSample(self.hydra7SoundId, hydra7SoundFile, false);
    self.hydra7Playing = false;	

end;	
      
function Shield:delete()
end;

function Shield:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Shield:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_l then
		self.rotation7Max = isDown;
	end;
	if sym == Input.KEY_k then
		self.rotation7Min = isDown;
	end;
	
end;

function Shield:update(dt)
			
	local doRotate = self.rotation7Max or self.rotation7Min 
	if self.rotation7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7Max);
        setRotation(self.rotation7.node, unpack(newRot));
        if not self.hydra7Playing then
            playSample(self.hydra7SoundId, 0, 1, 0);
            self.hydra7Playing = true;
        end;
    else
        if self.hydra7Playing then
            stopSample(self.hydra7SoundId);
            self.hydra7Playing = false;
        end;
    end;
		
end;

function Shield:draw()
end;

function Shield:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
