Raba_Cultivator = {};

function Raba_Cultivator.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function Raba_Cultivator:load(xmlFile)
	self.drumNodeLeft1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index1"));
	self.drumNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index2"));
	self.drumNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index3"));
	self.drumNodeRight1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index4"));
	self.drumNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index5"));
	self.drumNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index6"));
	self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
	
  self.safeMode = true;

  self.allowSpray = false;
  self.alsoSpray = false;
	
	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 100)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
    
    	local rotationPartNodeFarRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartFarRight#index"));
    if rotationPartNodeFarRight ~= nil then
        self.rotationPartFarRight = {};
        self.rotationPartFarRight.node = rotationPartNodeFarRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFarRight#minRot"));
        self.rotationPartFarRight.minRot = {};
        self.rotationPartFarRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartFarRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartFarRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFarRight#maxRot"));
        self.rotationPartFarRight.maxRot = {};
        self.rotationPartFarRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartFarRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartFarRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartFarRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFarRight#rotTime"), 100)*1000;
        self.rotationPartFarRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFarRight#touchRotLimit"), 10));
    end; 
    
	
	
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 100)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
    
    	local rotationPartNodeFarLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartFarLeft#index"));
    if rotationPartNodeFarLeft ~= nil then
        self.rotationPartFarLeft = {};
        self.rotationPartFarLeft.node = rotationPartNodeFarLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFarLeft#minRot"));
        self.rotationPartFarLeft.minRot = {};
        self.rotationPartFarLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartFarLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartFarLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFarLeft#maxRot"));
        self.rotationPartFarLeft.maxRot = {};
        self.rotationPartFarLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartFarLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartFarLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartFarLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFarLeft#rotTime"), 100)*1000;
        self.rotationPartFarLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFarLeft#touchRotLimit"), 10));
    end;      
    
	
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        self.workSound = createSample("workSound");
        loadSample(self.workSound, workSound, false);
    end;
	
	local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
	
	self.threshingParticleSystems1 = {};
    local psName = "vehicle.threshingParticleSystem1";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems1, psName, self.rootNode, false)
	
	self.threshingParticleSystems2 = {};
    local psName = "vehicle.threshingParticleSystem2";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems2, psName, self.rootNode, false)
	
	self.threshingParticleSystems3 = {};
    local psName = "vehicle.threshingParticleSystem3";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems3, psName, self.rootNode, false)
	
	self.threshingParticleSystems4 = {};
    local psName = "vehicle.threshingParticleSystem4";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems4, psName, self.rootNode, false)
	
	self.threshingParticleSystems5 = {};
    local psName = "vehicle.threshingParticleSystem5";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems5, psName, self.rootNode, false)
	
	self.threshingParticleSystems6 = {};
    local psName = "vehicle.threshingParticleSystem6";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems6, psName, self.rootNode, false)
	
	self.threshingParticleSystems7 = {};
    local psName = "vehicle.threshingParticleSystem7";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems7, psName, self.rootNode, false)
	
	self.threshingParticleSystems8 = {};
    local psName = "vehicle.threshingParticleSystem8";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems8, psName, self.rootNode, false)
	
	self.threshingParticleSystems9 = {};
    local psName = "vehicle.threshingParticleSystem9";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems9, psName, self.rootNode, false)
	
	self.threshingParticleSystems10 = {};
    local psName = "vehicle.threshingParticleSystem10";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems10, psName, self.rootNode, false)
	
	self.threshingParticleSystems11 = {};
    local psName = "vehicle.threshingParticleSystem11";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems11, psName, self.rootNode, false)
	
	self.threshingParticleSystems12 = {};
    local psName = "vehicle.threshingParticleSystem12";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems12, psName, self.rootNode, false)
	
	self.threshingParticleSystems13 = {};
    local psName = "vehicle.threshingParticleSystem13";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems13, psName, self.rootNode, false)
	
	self.threshingParticleSystems14 = {};
    local psName = "vehicle.threshingParticleSystem14";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems14, psName, self.rootNode, false)
	
	self.threshingParticleSystems15 = {};
    local psName = "vehicle.threshingParticleSystem15";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems15, psName, self.rootNode, false)
	
	self.threshingParticleSystems16 = {};
    local psName = "vehicle.threshingParticleSystem16";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems16, psName, self.rootNode, false)
	 
	self.rotationMaxRight = true;
	self.rotationMaxLeft = true;
  self.rotationMaxFarRight = true;
	self.rotationMaxFarLeft = true;	
	self.translationMax2 = false;
	self.translationMax3 = false;
	 
end;

function Raba_Cultivator:delete()
end;


function Raba_Cultivator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Raba_Cultivator:keyEvent(unicode, sym, modifier, isDown)
end;


function Raba_Cultivator:update(dt)
	if self: getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxlsafe) then
			self.safeMode = not self.safeMode;
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxllow) then
			self.translationMax2 = not self.translationMax2;
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxlfold) then
			local srmr = self.rotationPartFarRight.rotTime;
    			local srml = self.rotationPartFarLeft.rotTime;
    			self.rotationPartFarRight.rotTime = self.rotationPartRight.rotTime;
    			self.rotationPartFarLeft.rotTime = self.rotationPartLeft.rotTime;
    			self.rotationPartRight.rotTime = srmr;
    			self.rotationPartLeft.rotTime = srml;
			self.rotationMaxRight = not self.rotationMaxRight;
			self.rotationMaxLeft = not self.rotationMaxLeft;
			self.rotationMaxFarRight = not self.rotationMaxFarRight;
			self.rotationMaxFarLeft = not self.rotationMaxFarLeft;
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxlSpray) then
			self.alsoSpray = not self.alsoSpray;
    			if not self.allowSpray then
      				self.alsoSpray = false;
    			end;
		end;
	end;

	if self.attacherVehicle then
		self.isExpandedRight = false;
       		if self.rotationPartRight ~= nil and self.rotationPartFarRight ~= nil then
            		local x, y, z = getRotation(self.rotationPartRight.node);
            		local farx, fary, farz = getRotation(self.rotationPartFarRight.node);
            		local minRot = self.rotationPartRight.minRot;
            		local farminRot = self.rotationPartFarRight.minRot;
            		local eps = self.rotationPartRight.touchRotLimit;
            		local fareps = self.rotationPartFarRight.touchRotLimit;

            		if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                		self.isExpandedRight = true;
                		if math.abs(farx - farminRot[1]) < fareps and math.abs(fary - farminRot[2]) < fareps and math.abs(farz - farminRot[3]) < fareps then
                  			self.isExpandedFarRight = true;
                		end;
           		end;
        	end;
		self.translationMax3 = true;

		if anhyTrailer ~= nil and anhyTrailer.fillLevel > 0 then
			self.allowSpray = true;
		end;
		
		if self.translationMax2 and self.isExpandedRight then
			Utils.setEmittingState(self.threshingParticleSystems1, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems2, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems3, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems4, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems5, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems6, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems7, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems8, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems9, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems10, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems11, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems12, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems13, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems14, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems15, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems16, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			
			if self.drumNodeLeft1 ~= nil then
				rotate(self.drumNodeLeft1, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeLeft2 ~= nil then
				rotate(self.drumNodeLeft2, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeLeft3 ~= nil then
				rotate(self.drumNodeLeft3, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight1 ~= nil then
				rotate(self.drumNodeRight1, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight2 ~= nil then
				rotate(self.drumNodeRight2, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight3 ~= nil then
				rotate(self.drumNodeRight3, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			
			if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.updateCultivatorArea (x, z, x1, z1, x2, z2, not self.safeMode);
			  
				if self.allowSpray and self.alsoSpray then
          				if anhyTrailer.fillLevel > 0 then
            					Utils.updateSprayArea(x,z,x1,z1,x2,z2);
            					local difLvl = g_currentMission.missionStats.difficulty;
            					local difMult = math.max(math.pow(difLvl,difLvl-1) +4 * (math.pow(difLvl-3,difLvl)),1);
            					anhyTrailer:setFillLevel(anhyTrailer.fillLevel - (self.attacherVehicle.lastSpeed * 18 * difMult) , anhyTrailer.currentFillType);          
          				else
            					self.allowSpray = false;
          				end;
				end;
        		end;
		end;
		if self.translationMax2 and self.isExpandedRight and self.attacherVehicle.lastSpeed*3600 > 2 then
			if not self.workSoundRunning then
                		print("start");
                		playSample(self.workSound, 0, 1.6, 0);
                		self.workSoundRunning = true;
			end;
		end;
		
		if not self.translationMax2 or not self.isExpandedRight or self.attacherVehicle.lastSpeed*3600 < 2 then
			if self.workSoundRunning then
                		print("end");
                		stopSample(self.workSound, 0, 1.6, 0);
                		self.workSoundRunning = false;
			end;
			
			Utils.setEmittingState(self.threshingParticleSystems1, false);
			Utils.setEmittingState(self.threshingParticleSystems2, false);
			Utils.setEmittingState(self.threshingParticleSystems3, false);
			Utils.setEmittingState(self.threshingParticleSystems4, false);
			Utils.setEmittingState(self.threshingParticleSystems5, false);
			Utils.setEmittingState(self.threshingParticleSystems6, false);
			Utils.setEmittingState(self.threshingParticleSystems7, false);
			Utils.setEmittingState(self.threshingParticleSystems8, false);
			Utils.setEmittingState(self.threshingParticleSystems9, false);
			Utils.setEmittingState(self.threshingParticleSystems10, false);
			Utils.setEmittingState(self.threshingParticleSystems11, false);
			Utils.setEmittingState(self.threshingParticleSystems12, false);
			Utils.setEmittingState(self.threshingParticleSystems13, false);
			Utils.setEmittingState(self.threshingParticleSystems14, false);
			Utils.setEmittingState(self.threshingParticleSystems15, false);
			Utils.setEmittingState(self.threshingParticleSystems16, false);
		end;
	end;
	
		
	local doTranslate = self.translationMax or self.translationMin;

	if self.translationPart ~= nil and doTranslate then
        	local x, y, z = getTranslation(self.translationPart.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        	setTranslation(self.translationPart.node, unpack(newTrans));
	end;

    	if self.rotationPartRight ~= nil then
        	local x, y, z = getRotation(self.rotationPartRight.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        	setRotation(self.rotationPartRight.node, unpack(newRot));
    	end;

    	if self.rotationPartLeft ~= nil then
        	local x, y, z = getRotation(self.rotationPartLeft.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        	setRotation(self.rotationPartLeft.node, unpack(newRot));
    	end;
    
    	if self.rotationPartFarRight ~= nil then
        	local x, y, z = getRotation(self.rotationPartFarRight.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartFarRight.maxRot, self.rotationPartFarRight.minRot, 3, self.rotationPartFarRight.rotTime, dt, not self.rotationMaxFarRight);
        	setRotation(self.rotationPartFarRight.node, unpack(newRot));
    	end;

    	if self.rotationPartFarLeft ~= nil then
        	local x, y, z = getRotation(self.rotationPartFarLeft.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartFarLeft.maxRot, self.rotationPartFarLeft.minRot, 3, self.rotationPartFarLeft.rotTime, dt, not self.rotationMaxFarLeft);
        	setRotation(self.rotationPartFarLeft.node, unpack(newRot));
    	end;   	
	
	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        	setTranslation(self.translationPart2.node, unpack(newTrans));
	end;
	
	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        	setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
end;

function Raba_Cultivator:attachImplement(implement)
    	anhyTrailer = implement.object;
    	if anhyTrailer.fillLevel > 0 then
		self.allowSpray = true;
	end;
    
end;

function Raba_Cultivator:detachImplement(implementIndex)
	local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_TRAILER then
        self.allowSpray = false;
        self.alsoSpray = false;
        self.anhyTrailer = nil;
    end;
end;

function Raba_Cultivator:draw()
	if self.safeMode then
		g_currentMission: addHelpButtonText("Switch to normal mode", InputBinding.GregoireBessonxxlsafe);
	else
		g_currentMission: addHelpButtonText("Switch to safe mode", InputBinding.GregoireBessonxxlsafe);
	end; 

	if self.allowSpray then
		if self.alsoSpray then
			g_currentMission: addHelpButtonText("Spray Off", InputBinding.GregoireBessonxxlSpray);
		else
			g_currentMission: addHelpButtonText("Spray On", InputBinding.GregoireBessonxxlSpray);
		end;
	end;

	if self.rotationMaxLeft then
		g_currentMission: addHelpButtonText("Unfold Cultivator", InputBinding.GregoireBessonxxlfold);
	else
		g_currentMission: addHelpButtonText("Fold Cultivator", InputBinding.GregoireBessonxxlfold);
	end;
	
  
	if self.translationMax2 then
		g_currentMission: addHelpButtonText("Raise Cultivator", InputBinding.GregoireBessonxxllow);
	else
		g_currentMission: addHelpButtonText("Lower Cultivator", InputBinding.GregoireBessonxxllow);
	end;

end;