--
-- AlternativeTippingTrailerFix
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

old_trailer_load = Trailer.load;
old_trailer_update = Trailer.update;
old_trailer_draw = Trailer.draw;

Trailer.load = function(self, xmlFile)
	old_trailer_load(self, xmlFile);
	self.triggerPlacement = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.alternativeTipping#triggerPlacement"));
	
	self.isTriggerPlaceDefined = true;
	if self.triggerPlacement == nil then
		self.triggerPlacement = self.tipReferencePoint;
		self.isTriggerPlaceDefined = false;
	end;
	
	self.printTriggerError = 0;
	self.printTriggerPlaceError = 0;
end;

Trailer.update = function(self, dt)
	old_trailer_update(self, dt);
	
	if self:getIsActive() then
		self.isInActiveTipRange = g_currentMission.trailerInTipRange == self;
		if not self.isInActiveTipRange and self.fillLevel > 0 and not self.isShovel and self.tipState == Trailer.TIPSTATE_CLOSED then
			if self:getIsActiveForInput() and g_currentMission.alternativeTipTrigger:getTriggerByFilltype(Fillable.fillTypeIntToName[self.currentFillType]) ~= nil then
				if Input.isKeyPressed(Input.KEY_lctrl) and InputBinding.hasEvent(InputBinding.ALTERNATIVETIPPING_START_TIPPING) then
					-- get current tipReferencePoint if no triggerplacement is defined
					if not self.isTriggerPlaceDefined then
						self.triggerPlacement = self.tipReferencePoint;
					end;
					local allowed = true;
					for _, trigger in pairs(g_currentMission.tipTriggers) do
						if trigger.isExtendedTrigger and trigger.currentFillType ~= self.currentFillType then
							local x1,y1,z1 = getWorldTranslation(self.triggerPlacement);
							local x2,y2,z2 = getWorldTranslation(trigger.triggerId);
							local distance = Utils.vector3Length(x2-x1,y2-y1,z2-z1);
							if distance < 10 then
								allowed = false;
								self.printTriggerError = self.time + 3500;
							end;
						end;
					end;	
					if allowed then
						g_currentMission.alternativeTipTrigger:addNewTrigger(self, false, false);
					end;
				end;
			end;
		end;
	end;
end;

Trailer.draw = function(self)
	old_trailer_draw(self);
	if self:getIsActiveForInput() then
		if not self.isInActiveTipRange and self.fillLevel > 0 and self.tipState == Trailer.TIPSTATE_CLOSED then
			if g_currentMission.alternativeTipTrigger:getTriggerByFilltype(Fillable.fillTypeIntToName[self.currentFillType]) ~= nil and not self.isShovel then
				g_currentMission:addHelpButtonText(g_i18n:getText("ALTERNATIVETIPPING_START_TIPPING"), InputBinding.ALTERNATIVETIPPING_START_TIPPING);
			end;
		end;
		if self.time < self.printTriggerError then
			g_currentMission:addWarning(g_i18n:getText("ALTERNATIVETIPPING_TIPPING_NOT_ALLOWED"), 0.018, 0.033);
		end;
	end;
end;