--
-- BrookLodgeFarm
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BrookLodgeFarm = {}

local BrookLodgeFarm_mt = Class(BrookLodgeFarm, Mission00);

function BrookLodgeFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BrookLodgeFarm_mt;
    end;
    local self = BrookLodgeFarm:superClass():new(baseDirectory, mt);
    return self;
end;

function BrookLodgeFarm:delete()
    BrookLodgeFarm:superClass().delete(self);
end;

function BrookLodgeFarm:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    BrookLodgeFarm:superClass().load(self);
end
function BrookLodgeFarm:loadFinished()
    BrookLodgeFarm:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function BrookLodgeFarm:mouseEvent(posX, posY, isDown, isUp, button)
    BrookLodgeFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BrookLodgeFarm:keyEvent(unicode, sym, modifier, isDown)
    BrookLodgeFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BrookLodgeFarm:update(dt)
    BrookLodgeFarm:superClass().update(self, dt);
end;

function BrookLodgeFarm:draw()
    BrookLodgeFarm:superClass().draw(self);
end;
