Caisson = {};

function Caisson.prerequisitesPresent(specializations)
    return true
end;

function Caisson:load(xmlFile)
	------ Prise de force ------
	
	self.drum1= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.priseDeForce#index"));
    self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.priseDeForce#rotationScale"), 1);
	
	------- Lever du caisson -------
	local rotationNodePartCaisson = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCaisson#index"));
    if rotationNodePartCaisson ~= nil then
        self.rotationPartCaisson = {};
        self.rotationPartCaisson.node = rotationNodePartCaisson;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCaisson#minRot"));
        self.rotationPartCaisson.minRot = {};
        self.rotationPartCaisson.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCaisson.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCaisson.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCaisson#maxRot"));
        self.rotationPartCaisson.maxRot = {};
        self.rotationPartCaisson.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCaisson.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCaisson.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCaisson.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCaisson#rotTime"), 2)*1000;
        self.rotationPartCaisson.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCaisson#touchRotLimit"), 10));
    end;  
	
	local rotationPartCyl1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCyl1#index"));
    if rotationPartCyl1Node ~= nil then
        self.rotationPartCyl1 = {};
        self.rotationPartCyl1.node = rotationPartCyl1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl1#minRot"));
        self.rotationPartCyl1.minRot = {};
        self.rotationPartCyl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl1#maxRot"));
        self.rotationPartCyl1.maxRot = {};
        self.rotationPartCyl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCyl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl1#rotTime"), 2)*1000;
        self.rotationPartCyl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl1#touchRotLimit"), 10));
    end;
	local translationNodeVerrain1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain1#index"));
    if translationNodeVerrain1 ~= nil then
        self.translationVerrain1 = {};
        self.translationVerrain1.node = translationNodeVerrain1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain1#minTrans"));
        self.translationVerrain1.minTrans = {};
        self.translationVerrain1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain1#maxTrans"));
        self.translationVerrain1.maxTrans = {};
        self.translationVerrain1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain1#transTime"), 2)*1000;
        self.translationVerrain1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain1#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain2#index"));
    if translationNodeVerrain2~= nil then
        self.translationVerrain2 = {};
        self.translationVerrain2.node = translationNodeVerrain2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain2#minTrans"));
        self.translationVerrain2.minTrans = {};
        self.translationVerrain2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain2#maxTrans"));
        self.translationVerrain2.maxTrans = {};
        self.translationVerrain2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain2#transTime"), 2)*1000;
        self.translationVerrain2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain2#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain3#index"));
    if translationNodeVerrain3~= nil then
        self.translationVerrain3 = {};
        self.translationVerrain3.node = translationNodeVerrain3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain3#minTrans"));
        self.translationVerrain3.minTrans = {};
        self.translationVerrain3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain3#maxTrans"));
        self.translationVerrain3.maxTrans = {};
        self.translationVerrain3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain3#transTime"), 2)*1000;
        self.translationVerrain3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain3#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain4#index"));
    if translationNodeVerrain4~= nil then
        self.translationVerrain4 = {};
        self.translationVerrain4.node = translationNodeVerrain4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain4#minTrans"));
        self.translationVerrain4.minTrans = {};
        self.translationVerrain4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain4#maxTrans"));
        self.translationVerrain4.maxTrans = {};
        self.translationVerrain4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain4#transTime"), 2)*1000;
        self.translationVerrain4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain4#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain5#index"));
    if translationNodeVerrain5~= nil then
        self.translationVerrain5 = {};
        self.translationVerrain5.node = translationNodeVerrain5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain5#minTrans"));
        self.translationVerrain5.minTrans = {};
        self.translationVerrain5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain5#maxTrans"));
        self.translationVerrain5.maxTrans = {};
        self.translationVerrain5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain5#transTime"), 2)*1000;
        self.translationVerrain5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain5#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain6#index"));
    if translationNodeVerrain6~= nil then
        self.translationVerrain6 = {};
        self.translationVerrain6.node = translationNodeVerrain6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain6#minTrans"));
        self.translationVerrain6.minTrans = {};
        self.translationVerrain6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain6#maxTrans"));
        self.translationVerrain6.maxTrans = {};
        self.translationVerrain6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain6#transTime"), 2)*1000;
        self.translationVerrain6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain6#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain7#index"));
    if translationNodeVerrain7~= nil then
        self.translationVerrain7 = {};
        self.translationVerrain7.node = translationNodeVerrain7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain7#minTrans"));
        self.translationVerrain7.minTrans = {};
        self.translationVerrain7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain7#maxTrans"));
        self.translationVerrain7.maxTrans = {};
        self.translationVerrain7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain7.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain7#transTime"), 2)*1000;
        self.translationVerrain7.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain7#touchTransLimit"), 10);
    end; 	
	local translationNodeVerrain8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain8#index"));
    if translationNodeVerrain8~= nil then
        self.translationVerrain8 = {};
        self.translationVerrain8.node = translationNodeVerrain8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain8#minTrans"));
        self.translationVerrain8.minTrans = {};
        self.translationVerrain8.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain8.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain8.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain8#maxTrans"));
        self.translationVerrain8.maxTrans = {};
        self.translationVerrain8.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain8.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain8.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain8.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain8#transTime"), 2)*1000;
        self.translationVerrain8.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain4#touchTransLimit"), 10);
    end; 	
 
	self.lever = false;	
end;

function Caisson:delete()
end;

function Caisson:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Caisson:keyEvent(unicode, sym, modifier, isDown)
	if sym == self.keys.caissonUP then 
		self.rotationPartCaissonMax = isDown;
		self.rotationPartCyl1Max = isDown;
		self.translationMax = isDown;
		self.lever = isDown;
	end;
	if sym == self.keys.caissonDOWN then
		self.rotationPartCaissonMin = isDown;
		self.rotationPartCyl1Min = isDown;
		self.translationMin = isDown;
		self.lever = false;
	end;		
end;

function Caisson:update(dt)

	-- Prise de force
	if self.lever then
		if self.drum1 ~= nil then
			rotate(self.drum1, 0 , 0, self.drumRotationScale * 3);
		end;
	end;

	--------- Caisson -------
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain1.maxTrans, self.translationVerrain1.minTrans, 3, self.translationVerrain1.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain1.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain2.maxTrans, self.translationVerrain2.minTrans, 3, self.translationVerrain2.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain2.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain3.maxTrans, self.translationVerrain3.minTrans, 3, self.translationVerrain3.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain3.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain4 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain4.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain4.maxTrans, self.translationVerrain4.minTrans, 3, self.translationVerrain4.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain4.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain5 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain5.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain5.maxTrans, self.translationVerrain5.minTrans, 3, self.translationVerrain5.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain5.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain6 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain6.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain6.maxTrans, self.translationVerrain6.minTrans, 3, self.translationVerrain6.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain6.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain7 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain7.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain7.maxTrans, self.translationVerrain7.minTrans, 3, self.translationVerrain7.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain7.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translationMax or self.translationMin
	if self.translationVerrain8 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationVerrain8.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain8.maxTrans, self.translationVerrain8.minTrans, 3, self.translationVerrain8.transTime, dt, not self.translationMax); 
		setTranslation(self.translationVerrain8.node, unpack(newTrans)); 
	end;
   local doRotate = self.rotationPartCaissonMax or self.rotationPartCaissonMin 
	if self.rotationPartCaisson ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCaisson.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCaisson.maxRot, self.rotationPartCaisson.minRot, 3, self.rotationPartCaisson.rotTime, dt, not self.rotationPartCaissonMax);
        setRotation(self.rotationPartCaisson.node, unpack(newRot));
    end;  
	local doRotate = self.rotationPartCyl1Max or self.rotationPartCyl1Min 
	if self.rotationPartCyl1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCyl1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCyl1.maxRot, self.rotationPartCyl1.minRot, 3, self.rotationPartCyl1.rotTime, dt, not self.rotationPartCyl1Max);
        setRotation(self.rotationPartCyl1.node, unpack(newRot));
    end;	
	
end;

function Caisson:draw()
	g_currentMission:addExtraPrintText("Touche U/Y : Lever/Descendre la benne");
end;
