--
-- bomford
-- Specialization for bomford superflow.
--
-- @author  	PeterJ - LS_UK modteam
-- @version 	v1.0
-- @date  		04/01/2012
--

flexitine = {};

function flexitine.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;


function flexitine:load(xmlFile)

	self.setTurnedOn = SpecializationUtil.callSpecializationsFunction("setTurnedOn");	

	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.turnedOn = false;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;

end;

function flexitine:delete()
end;

function flexitine:readStream(streamId, connection)
   self:setTurnedOn(streamReadBool(streamId), true);
end;

function flexitine:writeStream(streamId, connection)
	streamWriteBool(streamId, self.turnedOn);
end;

function flexitine:mouseEvent(posX, posY, isDown, isUp, button)
end;

function flexitine:keyEvent(unicode, sym, modifier, isDown)
end;

function flexitine:update(dt)
	--[[if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
		  self:setTurnedOn(not self.turnedOn);
		end;
	end;]]
end;

function flexitine:updateTick(dt)
	if self:getIsActive() then
	
		if self.movingDirection == 1 and self:isLowered(false) then
			if self.lastMovedDistance > 0.3 then
				self:setTurnedOn(true);
			end;
		else
			self:setTurnedOn(false);	
		end;
	
		if self.turnedOn then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;	
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
        end;
	end;
end;

function flexitine:draw()
	if self.turnedOn then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	end;
end;

function flexitine:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.turnedOn = false;
end;

function flexitine:onLeave()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.turnedOn = false;
end;

function flexitine:onDetach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.turnedOn = false;
end;

function flexitine:onAttach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.turnedOn = false;
end;

function flexitine:setTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.turnedOn = turnedOn;
end;


SetTurnedOnEvent = {};
SetTurnedOnEvent_mt = Class(SetTurnedOnEvent, Event);

InitEventClass(SetTurnedOnEvent, "SetTurnedOnEvent");

function SetTurnedOnEvent:emptyNew()
    local self = Event:new(SetTurnedOnEvent_mt);
    self.className="SetTurnedOnEvent";
    return self;
end;

function SetTurnedOnEvent:new(vehicle, turnedOn)
    local self = SetTurnedOnEvent:emptyNew()
    self.vehicle = vehicle;
	self.turnedOn = turnedOn;
    return self;
end;

function SetTurnedOnEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.turnedOn = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTurnedOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.turnedOn);
end;

function SetTurnedOnEvent:run(connection)   
	self.vehicle:setTurnedOn(self.turnedOn, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTurnedOnEvent:new(vehicle, self.turnedOn), nil, connection, self.vehicle);
    end;
end;

function SetTurnedOnEvent.sendEvent(vehicle, turnedOn, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTurnedOnEvent:new(vehicle, turnedOn), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTurnedOnEvent:new(vehicle, turnedOn));
		end;
	end;
end;