﻿--
-- Bobcat Vorne Script
--
-- by 
-- 


Vorne = {}

function Vorne.prerequisitesPresent(specializations)
	--Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Vorne:load(xmlFile)
	
	local rotationNode8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
        self.rotation8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#touchRotLimit"), 10));
    end;

    hydra8SoundFile = Utils.getFilename("Sound/hydra1.wav", self.baseDirectory);
    self.hydra8SoundId = createSample("HYDRotB_hydraRotB");
    loadSample(self.hydra8SoundId, hydra8SoundFile, false);
    self.hydra8Playing = false;	
stopSample(self.hydra8SoundId);
end;	
      
function Vorne:delete()
end;

function Vorne:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Vorne:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_k then                -- Vorne ab
		self.rotation8Max = isDown;
	end;
	if sym == Input.KEY_m then                -- Vorne auf
		self.rotation8Min = isDown;
	end;
	
end;

function Vorne:update(dt)
			
	local doRotate = self.rotation8Max or self.rotation8Min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
        if not self.hydra8Playing then
            playSample(self.hydra8SoundId, 0, 1, 0);
            self.hydra8Playing = true;
        end;
    else
        if self.hydra8Playing then
            stopSample(self.hydra8SoundId);
            self.hydra8Playing = false;
        end;
    end;
		
end;

function Vorne:draw()
end;

function Vorne:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
