-- Hydraulik1
-- Specialization for Bobcat mod
--
Hydraulik1 = {};

function Hydraulik1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Hydraulik1:load(xmlFile)	
	self.hydraulic1 = {};
	self.hydraulic1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic1#indexHydraulic1"));
	self.hydraulic1.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic1#indexPunch1"));
	self.hydraulic1.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic1#translationPunch1"));
	local ax, ay, az = getWorldTranslation(self.hydraulic1.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic1.translationPunch);
    self.hydraulic1.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.hydraulic1Point = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic1#hydraulicPoint1"));
	self.keys1 = {};
	self.keysDesc1 = {};
    local i=0;
end;  -- load

function Hydraulik1:delete()
end;
function Hydraulik1:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Hydraulik1:keyEvent(unicode, sym, modifier, isDown)
end;

function Hydraulik1:update(dt)
	if self.hydraulic1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic1.node);
		local bx, by, bz = getWorldTranslation(self.hydraulic1Point);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic1.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic1.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic1.punch, 0, 0, (distance-self.hydraulic1.punchDistance)*-1);
		end;
	end;
end;  -- update

function Hydraulik1:draw()
end;