-- Hydraulik
-- Specialization for Bobcat mod

Hydraulik = {};

function Hydraulik.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Hydraulik:load(xmlFile)	
	self.hydraulic = {};
	self.hydraulic.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
	self.hydraulic.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
	self.hydraulic.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
	local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
    self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.hydraulicPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
	self.keys = {};
	self.keysDesc = {};
    local i=0;
end;  -- load

function Hydraulik:delete()
end;
function Hydraulik:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Hydraulik:keyEvent(unicode, sym, modifier, isDown)
end;

function Hydraulik:update(dt)
	if self.hydraulic ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
		end;
	end;
end;  -- update

function Hydraulik:draw()
     renderText(0.76, 0.225, 0.02, "NumP 7/4..Arm auf/ab");
	 renderText(0.76, 0.210, 0.02, "NumP 8/5..Wekzeug auf/ab");	
end;