BizonGigant = {};

function BizonGigant.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function BizonGigant:load(xmlFile)
	self.objectInRange = BizonGigant.objectInRange;
	self.mountChopper = SpecializationUtil.callSpecializationsFunction("mountChopper");
	self.activateChopper = SpecializationUtil.callSpecializationsFunction("activateChopper");
	self.emptyGrainTank = SpecializationUtil.callSpecializationsFunction("emptyGrainTank");
	self.adjustReelSpeed = SpecializationUtil.callSpecializationsFunction("adjustReelSpeed");
	self.activateCutter = SpecializationUtil.callSpecializationsFunction("activateCutter");
	self.startThreshing = Utils.overwrittenFunction(self.startThreshing, BizonGigant.startThreshing);
	self.stopThreshing = Utils.overwrittenFunction(self.stopThreshing, BizonGigant.stopThreshing);
	self.stopAIThreshing = Utils.overwrittenFunction(self.stopAIThreshing, BizonGigant.stopAIThreshing);
	self.lockCutterAttacher = SpecializationUtil.callSpecializationsFunction("lockCutterAttacher");

	self.strawTilt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strawTilt#index"));
	if self.strawTilt ~= nil then
		setVisibility(self.strawTilt, true);
	end;
	
	self.chopper = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopper#rootNode"));
	if self.chopper ~= nil then
		setVisibility(self.chopper, false);
	end;
	
	self.chopperBelt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopper#beltNode"));
	if self.chopperBelt ~= nil then
		setVisibility(self.chopperBelt, false);
	end;
	
	self.chopperOptionsNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopper#optionsNode"));
	
    self.chopperActive = false;
	self.chopperMounted = false;
	
    self.helpPanelWidth = 0.285;
    self.helpPanelHeight = 0.3;
	self.helpPanelPoxX = 0.705;
    self.helpPanelPoxY = 0.578;
    self.helpPanelOverlay = Overlay:new("helpPanel", Utils.getFilename("Textures/Hud.png", self.baseDirectory), self.helpPanelPoxX, self.helpPanelPoxY, self.helpPanelWidth, self.helpPanelHeight);
	self.helpPanelActive = false;
	
	self.emptyGrainTankActive = false;
	self.allowEmptyGrainTank = false;
	
	local thresherLeverNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.thresherLever#index"));
    if thresherLeverNode ~= nil then
        self.thresherLever = {};
        self.thresherLever.node = thresherLeverNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.thresherLever#minRot"));
        self.thresherLever.minRot = {};
        self.thresherLever.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.thresherLever.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.thresherLever.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.thresherLever#maxRot"));
        self.thresherLever.maxRot = {};
        self.thresherLever.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.thresherLever.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.thresherLever.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.thresherLever.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.thresherLever#rotTime"), 2)*1000;
    end;
	
	local reelStartLeverNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reelStartLever#index"));
    if reelStartLeverNode ~= nil then
        self.reelStartLever = {};
        self.reelStartLever.node = reelStartLeverNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.reelStartLever#minRot"));
        self.reelStartLever.minRot = {};
        self.reelStartLever.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.reelStartLever.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.reelStartLever.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.reelStartLever#maxRot"));
        self.reelStartLever.maxRot = {};
        self.reelStartLever.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.reelStartLever.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.reelStartLever.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.reelStartLever.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.reelStartLever#rotTime"), 2)*1000;
    end;
	
	local cutterLoweringLeverNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cutterLoweringLever#index"));
    if cutterLoweringLeverNode ~= nil then
        self.cutterLoweringLever = {};
        self.cutterLoweringLever.node = cutterLoweringLeverNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cutterLoweringLever#minRot"));
        self.cutterLoweringLever.minRot = {};
        self.cutterLoweringLever.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cutterLoweringLever.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cutterLoweringLever.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cutterLoweringLever#maxRot"));
        self.cutterLoweringLever.maxRot = {};
        self.cutterLoweringLever.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cutterLoweringLever.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cutterLoweringLever.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cutterLoweringLever.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cutterLoweringLever#rotTime"), 2)*1000;
    end;
	self.cutterLowered = false;
	
	local reelSpeedLeverNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reelSpeedLever#index"));
   	 if reelSpeedLeverNode ~= nil then
        self.reelSpeedLever = {};
        self.reelSpeedLever.node = reelSpeedLeverNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.reelSpeedLever#minRot"));
        self.reelSpeedLever.minRot = {};
        self.reelSpeedLever.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.reelSpeedLever.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.reelSpeedLever.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.reelSpeedLever#maxRot"));
        self.reelSpeedLever.maxRot = {};
        self.reelSpeedLever.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.reelSpeedLever.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.reelSpeedLever.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.reelSpeedLever.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.reelSpeedLever#rotTime"), 2)*1000;
        self.reelSpeedLever.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.reelSpeedLever#touchRotLimit"), 10));
    end;
	
	self.threshingUVScrollParts = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.threshingUVScrollParts.threshingUVScrollPart(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
		if node ~= nil and speed then
			table.insert(self.threshingUVScrollParts, {node=node, speed=speed});
		end;
		i = i +1;
	end;
	
	self.cutterUVScrollParts = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.cutterUVScrollParts.cutterUVScrollPart(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
		if node ~= nil and speed then
			table.insert(self.cutterUVScrollParts, {node=node, speed=speed});
		end;
		i = i +1;
	end;
	
	self.chopperParticleSystemsBackup = self.chopperParticleSystems;
	self.standardChopperParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.standardChopperParticleSystems.standardChopperParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.standardChopperParticleSystems[desc.index] = currentPS;
		end;
		i = i + 1;
	end;
	
	self.chopperParticleSystems = self.standardChopperParticleSystems;
 
	self.startThreshingExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startThreshingExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.startThreshingExhaustParticleSystems.startThreshingExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.startThreshingExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	self.threshingEnableTime = nil;
	
	self.thresherParticleSystems = {};
	local psName = "vehicle.thresherParticleSystem";
	Utils.loadParticleSystem(xmlFile, self.thresherParticleSystems, psName, self.components, false, nil, self.baseDirectory)
	
	self.currentReelSpeed = 1;
	self.minReelSpeed = 0.3;
	self.maxReelSpeed = 1.7;
	
	self.cutterActivated = false;
	self.reelFaster = false;
	self.reelSlower = false;
	
	for k, jointDesc in pairs(self.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.maxRotBackup = jointDesc.maxRot;
		end;
	end;
	
	self.attachCutterUpActive = false;
	
	self.attachedCutterHose = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterHydraulicHose#attachedHoseIndex"));
	if self.attachedCutterHose ~= nil then
		setVisibility(self.attachedCutterHose, false);
	end;
	
	self.detachedCutterHose = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterHydraulicHose#detachedHoseIndex"));
	if self.detachedCutterHose ~= nil then
		setVisibility(self.detachedCutterHose, true);
	end;
	
	self.currentCutterHasReel = false;
end;

function BizonGigant:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'chopperMounted="'.. tostring(self.chopperMounted) ..'" chopperActivated="'.. tostring(self.chopperActive) ..'"';
	return attributes, nil;
end;

function BizonGigant:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local chopperMounted = Utils.getNoNil(getXMLBool(xmlFile, key.."#chopperMounted"), false);
		local chopperActivated = Utils.getNoNil(getXMLBool(xmlFile, key.."#chopperActivated"), false);
		self:mountChopper(chopperMounted);
		self:activateChopper(chopperActivated);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function BizonGigant:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BizonGigant:delete()
	Utils.deleteParticleSystem(self.startThreshingExhaustParticleSystems);
	Utils.deleteParticleSystem(self.thresherParticleSystems);
end;

function BizonGigant:keyEvent(unicode, sym, modifier, isDown)
end;

function BizonGigant:readStream(streamId, connection)
	self:activateChopper(streamReadBool(streamId), true);
	self:mountChopper(streamReadBool(streamId), true);
	self:emptyGrainTank(streamReadBool(streamId), true);
	self:activateCutter(streamReadBool(streamId), true);
	self:adjustReelSpeed(streamReadFloat32(streamId), true);
	self:lockCutterAttacher(streamReadBool(streamId), true);
end;

function BizonGigant:writeStream(streamId, connection)
	streamWriteBool(streamId, self.chopperActive);
	streamWriteBool(streamId, self.chopperMounted);
	streamWriteBool(streamId, self.emptyGrainTankActive);
	streamWriteBool(streamId, self.cutterActivated);
	streamWriteFloat32(streamId, self.currentReelSpeed);
	streamWriteBool(streamId, self.attachCutterUpActive);
end;

function BizonGigant:update(dt)
	self.reelFaster = false;
	self.reelSlower = false;
	if self:getIsActiveForInput() then
		if self.numAttachedCutters > 0 then
			if self.currentCutterHasReel == true then
				if InputBinding.isPressed(InputBinding.BizonGigant_ReelSlower) then
					if self.currentReelSpeed > self.minReelSpeed then
						self.reelSlower = true;
						self:adjustReelSpeed(self.currentReelSpeed - 0.01);
					end;
				elseif InputBinding.isPressed(InputBinding.BizonGigant_ReelFaster) then
					if self.currentReelSpeed < self.maxReelSpeed then
						self.reelFaster = true;
						self:adjustReelSpeed(self.currentReelSpeed + 0.01);
					end;
				end;
			end;
			
			if InputBinding.hasEvent(InputBinding.BizonGigant_ActivateCutter) then
				self:activateCutter(not self.cutterActivated);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.BizonGigant_HelpPanel) then
			self.helpPanelActive = not self.helpPanelActive;
		end;
		
		if self.allowEmptyGrainTank then
			if InputBinding.hasEvent(InputBinding.BizonGigant_EmptyGrainTank) then
				self:emptyGrainTank(not self.emptyGrainTankActive);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.BizonGigant_GrainTankCover) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].startPosition);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;

		if InputBinding.hasEvent(InputBinding.BizonGigant_Window) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].startPosition);
			elseif self.animationParts[7].clipStartTime then
				self:setAnimationTime(7, self.animationParts[7].animDuration);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.BizonGigant_Door) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].startPosition);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
	end;
	
	if self.isClient then
		if self:objectInRange(self.animationParts[3].rootNode) then
			if InputBinding.hasEvent(InputBinding.BizonGigant_OpenPanel) then
				if self.animationParts[3].clipEndTime then
					self:setAnimationTime(3, self.animationParts[3].startPosition);
				elseif self.animationParts[3].clipStartTime then
					self:setAnimationTime(3, self.animationParts[3].animDuration);
				end;
			end;
			if self.animationParts[3].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_ClosePanel")), InputBinding.BizonGigant_OpenPanel);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_OpenPanel")), InputBinding.BizonGigant_OpenPanel);
			end;
		end;

		if self:objectInRange(self.animationParts[4].rootNode) then
			if InputBinding.hasEvent(InputBinding.BizonGigant_OpenPanel) then
				if self.animationParts[4].clipEndTime then
					self:setAnimationTime(4, self.animationParts[4].startPosition);
				elseif self.animationParts[4].clipStartTime then
					self:setAnimationTime(4, self.animationParts[4].animDuration);
				end;
			end;
			if self.animationParts[4].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_ClosePanel")), InputBinding.BizonGigant_OpenPanel);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_OpenPanel")), InputBinding.BizonGigant_OpenPanel);
			end;
		end;
		
		if self:objectInRange(self.chopperOptionsNode) then
			if InputBinding.hasEvent(InputBinding.BizonGigant_ChopperMount) then
				self:mountChopper(not self.chopperMounted);
			end;
			if self.chopperMounted then
				if InputBinding.hasEvent(InputBinding.BizonGigant_ActivateChopper) then
					self:activateChopper(not self.chopperActive);
				end;
				if self.chopperActive then
					g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_DeactivateChopper"), InputBinding.BizonGigant_ActivateChopper);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_ActivateChopper"), InputBinding.BizonGigant_ActivateChopper);
				end;
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_ChopperUnmount")), InputBinding.BizonGigant_ChopperMount);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_ChopperMount")), InputBinding.BizonGigant_ChopperMount);
			end;
		end;
	end;
	
	if self:getIsActive() then
		self:setAnimationTime(8, 1);
	else
		self:setAnimationTime(8, 0);
	end
	
	if self.cutterActivated then
		self:setAnimationTime(11, 1);
	else
		self:setAnimationTime(11, 0);
	end;
	
	if self.isThreshing then
  		self:setAnimationTime(5, 1);
		self:setAnimationTime(6, 1);
		Utils.setEmittingState(self.thresherParticleSystems, true);
	else
		self:setAnimationTime(5, 0);
		self:setAnimationTime(6, 0);
		Utils.setEmittingState(self.thresherParticleSystems, false);
	end;
	
	if self.isThreshing and self.chopperActive then
		self:setAnimationTime(9, 1);
	else
		self:setAnimationTime(9, 0);
	end;

	if self.chopperActive then
		self.strawEmitState = false;
		self.strawEnableTime = nil;
		self.chopperActivated = true;
									
		if self.lastArea > 0 then
			if self.chopperActivated then
				if self.chopperEnableTime == nil then
					self.chopperEnableTime = self.time + self.chopperToggleTime;
				else
					self.chopperDisableTime = nil;
				end;
				disableChopperEmit = false;
			end;
			
			if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
				self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
				if self.currentChopperParticleSystem == nil then
					self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
				end;
				Utils.setEmittingState(self.currentChopperParticleSystem, true);
			end;
		end;	
	else
		if self.chopperMounted and self.lastArea > 0 then
			if self.chopperActivated == true and self.chopperActive == false then
				self:activateChopper(true);
			end;
		end;
    end;
	
	if self.isAIThreshing == false then
		self.pipeStateIsUnloading[2] = self.emptyGrainTankActive;
		local fruitType, fillLevel, useGrainTank = self:getFruitTypeAndFillLevelToUnload();
		if fillLevel > 0 then
			local trailer = self:findTrailerToUnload(fruitType);
			if trailer ~= nil then
				self.allowEmptyGrainTank = true;
			else
				self.allowEmptyGrainTank = false;
				self.emptyGrainTankActive = false;
			end;
		else
			self.allowEmptyGrainTank = false;
			self.emptyGrainTankActive = false;
		end;
	else
		self.pipeStateIsUnloading[2] = true;
	end;
	
	if self.thresherLever ~= nil then
		local x, y, z = getRotation(self.thresherLever.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.thresherLever.maxRot, self.thresherLever.minRot, 3, self.thresherLever.rotTime, dt, not self.isThreshing);
		setRotation(self.thresherLever.node, unpack(newRot));
	end;
	
	if self.reelStartLever ~= nil then
		local x, y, z = getRotation(self.reelStartLever.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.reelStartLever.maxRot, self.reelStartLever.minRot, 3, self.reelStartLever.rotTime, dt, not self.cutterActivated);
		setRotation(self.reelStartLever.node, unpack(newRot));
	end;
	
	for k, jointDesc in pairs(self.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER and jointDesc.moveDown ~= nil then
			self.cutterLowered = jointDesc.moveDown;
		end;
	end;

	if self.cutterLoweringLever ~= nil then
		local x, y, z = getRotation(self.cutterLoweringLever.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.cutterLoweringLever.maxRot, self.cutterLoweringLever.minRot, 3, self.cutterLoweringLever.rotTime, dt, not self.cutterLowered);
		setRotation(self.cutterLoweringLever.node, unpack(newRot));
	end;
	
	if self.isThreshing then
		if self.threshingEnableTime == nil then
			self.threshingEnableTime = self.time;
		end;
	else
		self.threshingEnableTime = nil;
	end;
	
	if self.isClient then
		if self.threshingEnableTime ~= nil and self.time <= (self.threshingEnableTime + 1000) then
			Utils.setEmittingState(self.startThreshingExhaustParticleSystems, true);
		else
			Utils.setEmittingState(self.startThreshingExhaustParticleSystems, false);
		end;
	end;
	
	for cutter,implement in pairs(self.attachedCutters) do
		setRotation(self.reelSpeedLever.node, Utils.degToRad(Utils.getNoNil((cutter.reelSpeedScale-0.3)*25, 0)), 0, 0);
		if cutter.reelNode ~= nil then
			self.currentCutterHasReel = true;
		else
			self.currentCutterHasReel = false;
		end;
	end;
	
	for _, part in pairs(self.threshingUVScrollParts) do
		if self.isThreshing then
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
		else
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;
	
	for _, part in pairs(self.cutterUVScrollParts) do
		if self.cutterActivated then
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
		else
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
	end;
	
	if self.isClient then
		if g_currentMission.attachableInMountRange ~= nil then
			if g_currentMission.attachableInMountRangeVehicle == self then
				for k, jointDesc in pairs(self.attacherJoints) do
					if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER and g_currentMission.attachableInMountRange.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
						local x, y, z = getWorldTranslation(jointDesc.jointTransform);
						local ax, ay, az = getWorldTranslation(g_currentMission.attachableInMountRange.attacherJoint.node);
						local heightDifference = y - ay;
						if heightDifference < 0.1 then
							if self.attachCutterUpActive then
								g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_UnlockCutterAttacher"), self.typeDesc), InputBinding.BizonGigant_LockCutterAttacher);
							else
								g_currentMission:addWarning(g_i18n:getText("BizonGigant_LockCutterAttacherInfo"), 0.07+0.022, 0.019+0.029);	
								g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigant_LockCutterAttacher"), self.typeDesc), InputBinding.BizonGigant_LockCutterAttacher);
							end;
							if InputBinding.hasEvent(InputBinding.BizonGigant_LockCutterAttacher) then
								self:lockCutterAttacher(not self.attachCutterUpActive);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if table.getn(self.attachedImplements) > 0 and self.attachCutterUpActive then
		self.attachCutterUpActive = false;
		for k, jointDesc in pairs(self.attacherJoints) do
			if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
				jointDesc.maxRot = jointDesc.maxRotBackup;
			end;
		end;
	end;
	
	if self.numAttachedCutters > 0 then
		for cutter,implement in pairs(self.attachedCutters) do
			if cutter.allowAttachHydraulicHose then
				if self.attachedCutterHose ~= nil then
					setVisibility(self.attachedCutterHose, true);
				end;
				if self.detachedCutterHose ~= nil then
					setVisibility(self.detachedCutterHose, false);
				end;
			else
				if self.attachedCutterHose ~= nil then
					setVisibility(self.attachedCutterHose, false);
				end;
				if self.detachedCutterHose ~= nil then
					setVisibility(self.detachedCutterHose, true);
				end;
			end;
		end;
	else
		if self.attachedCutterHose ~= nil then
			setVisibility(self.attachedCutterHose, false);
		end;
		if self.detachedCutterHose ~= nil then
			setVisibility(self.detachedCutterHose, true);
		end;
	end;
end;

function BizonGigant:updateTick(dt)   
end;

function BizonGigant:draw()
	if self.isClient then
		if self.allowEmptyGrainTank then
			if self.emptyGrainTankActive then
				g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_StopGrainDischarge"), InputBinding.BizonGigant_EmptyGrainTank);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_StartGrainDischarge"), InputBinding.BizonGigant_EmptyGrainTank);
			end;
		end;
		
		if self.numAttachedCutters > 0 then
			if self.cutterActivated then
				g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_DeactivateCutter"), InputBinding.BizonGigant_ActivateCutter);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_ActivateCutter"), InputBinding.BizonGigant_ActivateCutter);
			end;
		end;
		
		if self.helpPanelActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_HelpPanelOff"), InputBinding.BizonGigant_HelpPanel);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("BizonGigant_HelpPanelOn"), InputBinding.BizonGigant_HelpPanel);
		end;
		
		if self.helpPanelOverlay ~= nil then
			if self.helpPanelActive then
				self.helpPanelOverlay:render();
			end;
		end;	
		
		if self.helpPanelActive then
			if self.halogenyP then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.84, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Frontwork)..": "..g_i18n:getText("BizonGigant_Worklights"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.84, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Frontwork)..": "..g_i18n:getText("BizonGigant_Worklights"))));
			end;
			if self.animationParts[2].clipEndTime then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.82, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_GrainTankCover)..": "..g_i18n:getText("BizonGigant_GrainTankCover"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.82, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_GrainTankCover)..": "..g_i18n:getText("BizonGigant_GrainTankCover"))));
			end;
			if self.animationParts[1].clipEndTime then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.80, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Door)..": "..g_i18n:getText("BizonGigant_Door"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.80, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Door)..": "..g_i18n:getText("BizonGigant_Door"))));
			end;

			if self.animationParts[7].clipEndTime then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.78, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Window)..": "..g_i18n:getText("BizonGigant_Window"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.78, 0.018, (string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_Window)..": "..g_i18n:getText("BizonGigant_Window"))));
			end;
			if self.kierunekL then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.76, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3LEFT), "PAD", "")..": "..g_i18n:getText("BizonGigant_LeftBlinker"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.76, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3LEFT), "PAD", "")..": "..g_i18n:getText("BizonGigant_LeftBlinker"))));
			end;
			if self.awaryjne then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.74, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3WARN), "PAD", "")..": "..g_i18n:getText("BizonGigant_WarnLights"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.74, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3WARN), "PAD", "")..": "..g_i18n:getText("BizonGigant_WarnLights"))));
			end;
			if self.kierunekP then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.72, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("BizonGigant_RightBlinker"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.72, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_BEL3RIGHT), "PAD", "")..": "..g_i18n:getText("BizonGigant_RightBlinker"))));
			end;
			if self.numAttachedCutters > 0 and self.currentCutterHasReel == true then
				if self.reelSlower then
					setTextColor(0,1,0,1);
					renderText(0.72, 0.70, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_ReelSlower), "PAD", "")..": "..g_i18n:getText("BizonGigant_ReelSlower"))));
				else
					setTextColor(1,1,1,1);
					renderText(0.72, 0.70, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_ReelSlower), "PAD", "")..": "..g_i18n:getText("BizonGigant_ReelSlower"))));
				end;
				if self.reelFaster then
					setTextColor(0,1,0,1);
					renderText(0.72, 0.68, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_ReelFaster), "PAD", "")..": "..g_i18n:getText("BizonGigant_ReelFaster"))));
				else
					setTextColor(1,1,1,1);
					renderText(0.72, 0.68, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigant_ReelFaster), "PAD", "")..": "..g_i18n:getText("BizonGigant_ReelFaster"))));
				end;
			end;
		end;
		setTextColor(1,1,1,1);
	end;
end;

function BizonGigant:onEnter()
end;

function BizonGigant:onLeave()
end;

function BizonGigant:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function BizonGigant:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function BizonGigant:activateChopper(isActive, noEventSend)
	if isActive ~= self.chopperActive then
		ActivateChopperEvent.sendEvent(self, isActive, noEventSend);
		self.chopperActive = isActive;
		if self.chopperBelt ~= nil then
			setVisibility(self.chopperBelt, isActive);
		end;
		if isActive then
			self:setAnimationTime(10, self.animationParts[10].animDuration);
		else
			self:setAnimationTime(10, self.animationParts[10].startPosition);
		end;
	end;
end;

function BizonGigant:mountChopper(chopperMounted, noEventSend)
	MountChopperEvent.sendEvent(self, chopperMounted, noEventSend);
	self.chopperMounted = chopperMounted;
	if chopperMounted then
		self.chopperParticleSystems = self.chopperParticleSystemsBackup;
	else
		self.chopperParticleSystems = self.standardChopperParticleSystems;
	end;
	if self.strawTilt ~= nil then
		setVisibility(self.strawTilt, not chopperMounted);
	end;
	if self.chopper ~= nil then
		setVisibility(self.chopper, chopperMounted);
	end;
	if chopperMounted == false then
		self:activateChopper(false);
	end;
end;

function BizonGigant:emptyGrainTank(emptyGrainTankActive, noEventSend)
	EmptyGrainTankEvent.sendEvent(self, emptyGrainTankActive, noEventSend);
	self.emptyGrainTankActive = emptyGrainTankActive;
end;

function BizonGigant:onLeave()
	if self.deactivateOnLeave then
		self.onDeactivate(self);
	end;
end;

function BizonGigant:onDeactivate()
	for _, part in pairs(self.threshingUVScrollParts) do
		setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
	end;
	for _, part in pairs(self.cutterUVScrollParts) do
		setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
	end;
	Utils.setEmittingState(self.startThreshingExhaustParticleSystems, false);
	Utils.setEmittingState(self.thresherParticleSystems, false);
	self:activateCutter(false);
end;

function BizonGigant:startThreshing()
	if not self.isThreshing then
		if self.numAttachedCutters > 0 then
			self.chopperActivated = self.defaultChopperState;
			self.isThreshing = true;
			if self.isAIThreshing then
				self:activateCutter(true);
			end;

			if self.isClient then
				local threshingSoundOffset = 0;
				if self.threshingStartSound ~= nil then
					if self:getIsActiveForSound() then
						setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
						playSample(self.threshingStartSound, 1, 1, 0);
					end;
					threshingSoundOffset = getSampleDuration(self.threshingStartSound);
				end;

				self.playThreshingSoundTime = self.time+threshingSoundOffset;
			end;
		end;
	end;
end;

function BizonGigant:stopThreshing()
	if self.isThreshing then
		if self.isClient then
			if self.threshingSound ~= nil then
				stopSample(self.threshingSound);
			end;
			if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
				setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
				playSample(self.threshingStopSound, 1, 1, 0);
				self.threshingSoundActive = false;
			end;
		end;

		self.chopperActivated = false;
		self.isThreshing = false;

		--[[
		if self.isAIThreshing then
			self:activateCutter(false);
		end;
		]]
	end;
end;

function BizonGigant:activateCutter(isCutterStarted, noEventSend)
	ActivateCutterEvent.sendEvent(self, isCutterStarted, noEventSend);
	self.cutterActivated = isCutterStarted;
	for cutter,implement in pairs(self.attachedCutters) do
		if isCutterStarted then
			if self.isAIThreshing then
				self:setJointMoveDown(implement.jointDescIndex, true, true);
			end;
			--cutter:setReelSpeedScale(1); --0.003);
			cutter:onStartReel();
		else
			if self.isAIThreshing then
				self:setJointMoveDown(implement.jointDescIndex, false, true);
			end;
			cutter:onStopReel();
		end;
	end;
end;

function BizonGigant:stopAIThreshing(noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AICombineSetStartedEvent:new(self, false), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(AICombineSetStartedEvent:new(self, false));
		end;
	end;
	self:dismiss();

	if self.isAIThreshing then
		
		self.speedDisplayScale = 1;
		self.allowsThreshing = true;

		self.checkSpeedLimit = true;
		self.waitingForWeather = false;

		setVisibility(self.aiMotorSound, false);
		setVisibility(self.aiThreshingSound, false);
		self:setIsThreshing(false, true);
		self.isAIThreshing = false;
		if self.isServer then
			--restore allowsThreshing flag
			self.motor:setSpeedLevel(0, false);
			self.motor.maxRpmOverride = nil;

			WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, false, self.requiredDriveMode);

			if self.aiTrafficCollisionTrigger ~= nil then
				removeTrigger(self.aiTrafficCollisionTrigger);
			end;

			for cutter,implement in pairs(self.attachedCutters) do
				AICombine.removeCutterTrigger(self, cutter);
			end;
			if not self:getIsActive() then
				self:onLeave();
			end;
		end;
	end;
end;

function BizonGigant:adjustReelSpeed(reelSpeed, noEventSend)
	AdjustReelSpeedEvent.sendEvent(self, reelSpeed, noEventSend);
	self.currentReelSpeed = reelSpeed;
	for cutter,implement in pairs(self.attachedCutters) do
		cutter.reelSpeedScale = reelSpeed;
	end;
end;

function BizonGigant:detachImplement(implementIndex, noEventSend)
	local implement = self.attachedImplements[implementIndex];
	local jointDesc = self.attacherJoints[implement.jointDescIndex];
	if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
		self.cutterActivated = false;
	end;
end;

function BizonGigant:lockCutterAttacher(attachCutterUp, noEventSend)
	LockCutterAttacherEvent.sendEvent(self, attachCutterUp, noEventSend);
	self.attachCutterUpActive = attachCutterUp;
	for k, jointDesc in pairs(self.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			if attachCutterUp then
				jointDesc.maxRot = jointDesc.minRot;
			else
				jointDesc.maxRot = jointDesc.maxRotBackup;
			end;
		end;
	end;
end;