FKA6023 = {};

function FKA6023.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function FKA6023:load(xmlFile)
	self.customAttacher = {};
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#minRot"));
	self.customAttacher.minRot = {};
	self.customAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#maxRot"));
	self.customAttacher.maxRot = {};
	self.customAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	self.attacherBackup = {};
end;

function FKA6023:delete()
end;

function FKA6023:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FKA6023:keyEvent(unicode, sym, modifier, isDown)
end;

function FKA6023:update(dt)
end;

function FKA6023:updateTick(dt)
end;

function FKA6023:draw()
end;

function FKA6023:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, jointDesc in pairs(attacherVehicle.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			self.attacherBackup.minRot = jointDesc.minRot;
			self.attacherBackup.maxRot = jointDesc.maxRot;
			jointDesc.minRot = self.customAttacher.minRot;
			jointDesc.maxRot = self.customAttacher.maxRot;
		end;
	end;
end;

function FKA6023:onDetach()
	for k, jointDesc in pairs(self.av.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.minRot = self.attacherBackup.minRot;
			jointDesc.maxRot = self.attacherBackup.maxRot;
		end;
	end;
end;

function FKA6023:onLeave()
end;

function FKA6023:onDeactivate()
end;