-- @ New Holland ClaysonCutter's Corn cutter
-- @ Bayn
-- @ 30/04/2009
-- @ Thanks to Face & Outlaw is scripts that allowed me to understand and learn .lua scripting


ClaysonCutter = {};

function ClaysonCutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function ClaysonCutter:load(xmlFile)

	self.visNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis#index"));
	self.vis2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis2#index"));
	self.vis3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis3#index"));
	self.vis4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis4#index"));
	self.vis5Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis5#index"));
	self.vis6Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis6#index"));
	self.vis7Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis7#index"));
	self.vis8Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vis8#index"));
	self.pf1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pf1#index"));
	self.pf2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pf2#index"));


------------------------------------------
------ Dfinition des touches ------------
------------------------------------------


	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
	    self.isTurning = false;
end;

function ClaysonCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ClaysonCutter:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym==self.keys.conveyor then
		self.isTurning = not self.isTurning; 

	end;
	

end;


function ClaysonCutter:update(dt)


    if self.isTurning then
        rotate(self.visNode, -dt*2*3, 0, 0);
        rotate(self.vis2Node, -dt*2*3, 0, 0);
        rotate(self.vis3Node, -dt*2*3, 0, 0);
        rotate(self.vis4Node, -dt*2*3, 0, 0);
        rotate(self.vis5Node, -dt*2*3, 0, 0);
        rotate(self.vis6Node, -dt*2*3, 0, 0);
        rotate(self.vis7Node, -dt*2*3, 0, 0);
        rotate(self.vis8Node, -dt*2*3, 0, 0);
        rotate(self.pf1Node, -dt*1*3, 0, 0);
        rotate(self.pf2Node, -dt*1*3, 0, 0);
    end;

end;



function ClaysonCutter:draw()
end;

function ClaysonCutter:delete()
end;



function ClaysonCutter:onDetach()
	self.isTurning = false;
end;
