SetRightFlapEvent = {};
SetRightFlapEvent_mt = Class(SetRightFlapEvent, Event);

InitEventClass(SetRightFlapEvent, "SetRightFlapEvent");

function SetRightFlapEvent:emptyNew()
    local self = Event:new(SetRightFlapEvent_mt);
    self.className="SetRightFlapEvent";
    return self;
end;

function SetRightFlapEvent:new(vehicle, rightFlapState)
    local self = SetRightFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.rightFlapState = rightFlapState;
    return self;
end;

function SetRightFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rightFlapState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRightFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.rightFlapState);
end;

function SetRightFlapEvent:run(connection)   
	self.vehicle:SetRightFlap(self.rightFlapState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRightFlapEvent:new(self.vehicle, self.rightFlapState), nil, connection, self.vehicle);
    end;
end;

function SetRightFlapEvent.sendEvent(vehicle, rightFlapState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRightFlapEvent:new(vehicle, rightFlapState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRightFlapEvent:new(vehicle, rightFlapState));
		end;
	end;
end;