
--- ANIMATION PLAY
--- Autor Sandro ADM

Animations = {};

function Animations.prerequisitesPresent(specializations) 
 
return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Animations:load(xmlFile)


	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.animParts = {}
	
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
		local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
	end; 	
	
	
end;



function Animations:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Animations:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_v then	
	self.Go.Work = not self.Go.Work; 
		self.Done.Work = true;
	end;	
	
end;


function Animations:update(dt)	
	if self.attacherVehicle then  
		if self.Go.Work ~= nil and self.Done.Work ~= false then			
		self:anim("Work",false); 
		end; 			
	end;	
end;



function  Animations:draw()
end;



function Animations:onAttach()				
end;



function Animations:onDetach()
end;
		

function Animations:anim(varName, loopCheck)	

	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	

		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		
		end;
	end;
end; 




			

