--
-- superSiloTrigger
--
-- MOD by Defender
--

print("MapMOD: superSiloTrigger loaded 1.01");

superSiloTrigger = {};

function superSiloTrigger:OnCreate(id)
	print("superSiloTrigger:OnCreate");
  superSiloTrigger:triggerLoad(id);
end;

superSiloOnCreate = superSiloTrigger.OnCreate; 

function superSiloTrigger:triggerLoad(id)

  addTrigger(id, "superSiloTriggerCallback", self);

	self.fillSpeed = getUserAttribute(id, "fillSpeed");
	self.id = id;
  
	self.trailerInTrigger = 0;	
	self.fruitTriggerId = 0;
	
	self.fill = false;
	self.printText = false;
	
	self.fruits = {};
	local i = 0;
  for a=1, FruitUtil.NUM_FRUITTYPES do
    if (FruitUtil.fruitIndexToDesc[a].allowsSeeding) and (FruitUtil.fruitIndexToDesc[a].name~="grass") then
      i=i+1;
      self.fruits[i]=a;
      print("Allow:"..FruitUtil.fruitIndexToDesc[a].name);
    else
      print("Disallow:"..FruitUtil.fruitIndexToDesc[a].name);
    end;      
  end;
  self.fruitscount=i;
  self.actualfruit=1;
  local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.actualfruit].name);
  self.fillType = FruitUtil[key];
  self.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[self.actualfruit].hudFruitOverlayFilename, self.baseDirectory);
  self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);

  self.siloParticleSystemRoot = loadI3DFile("data/vehicles/particleSystems/wheatParticleSystemLong.i3d");
  local x,y,z = localToWorld(self.id, -0.05, 0.15, 0.05);
  print("x="..x.." y="..y.." z="..z);
  setTranslation(self.siloParticleSystemRoot, x, y, z);
  link(getRootNode(), self.siloParticleSystemRoot);

  for i=0, getNumOfChildren(self.siloParticleSystemRoot)-1 do
    local child = getChildAt(self.siloParticleSystemRoot, i);
    if getClassName(child) == "Shape" then
      local geometry = getGeometry(child);
      if geometry ~= 0 then
        if getClassName(geometry) == "ParticleSystem" then
          self.siloParticleSystem = geometry;
          print("mam geometrii");
        end;
      end;
    end;
  end;

  if self.siloParticleSystem ~= nil then
    setEmittingState(self.siloParticleSystem, false);
    print("Emituju");
  end;

  self.ShowHud=false; 	
end;

function superSiloTrigger:loadMap(name)  
end;

function superSiloTrigger:deleteMap()
end;

function superSiloTrigger:delete()
end;

function superSiloTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function superSiloTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function superSiloTrigger:update(dt)
  if self.trailerInTrigger ~= 0 then	
		local attachable = g_currentMission.objectToTrailer[self.trailerInTrigger];
		if attachable ~= nil and attachable:getIsActiveForInput() then		
		  if InputBinding.hasEvent(InputBinding.SUPERSILO_FILL)  then
			  self.fill = not self.fill; 
		  end; 
		  if self.fill and self.printText then
			  g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STOPFILL"),InputBinding.SUPERSILO_FILL); 
		  elseif self.printText then
			  g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STARTFILL"),InputBinding.SUPERSILO_FILL); 
		  end; 
		  self.printText = false;
		
			if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
        if not self.fill then
          g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_CHOOSEFRUIT"),InputBinding.IMPLEMENT_EXTRA2);
          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2)  then
            self.actualfruit=self.actualfruit+1;
            if self.actualfruit>self.fruitscount then
              self.actualfruit=1;
            end;
            local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name);
            self.fillType = FruitUtil[key];
            self.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].hudFruitOverlayFilename, self.baseDirectory);
            self.ShowHud=false;  
            self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);           
		      end; 
        end;
        
        self.ShowHud=true;
        local realFillType = FruitUtil.fruitTypeToFillType[self.fillType];
        local fillName = Fillable.fillTypeIntToName[realFillType]; 
        
				if realFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
					if attachable.fillLevel < attachable.capacity and attachable:allowFillType(realFillType, true) then
						if self.fill then
							local deltaFillLevel = dt*self.fillSpeed;
              if g_currentMission.missionStats.farmSiloAmounts[realFillType]<=deltaFillLevel then
                deltaFillLevel=g_currentMission.missionStats.farmSiloAmounts[realFillType];
                self.fill=false;
              end;
              if deltaFillLevel>0 then 															
							  attachable:setFillLevel(attachable.fillLevel+deltaFillLevel, realFillType);
                g_currentMission.missionStats.farmSiloAmounts[realFillType]=g_currentMission.missionStats.farmSiloAmounts[realFillType]-deltaFillLevel;
                setEmittingState(self.siloParticleSystem, true);
              end;
              if g_currentMission.missionStats.farmSiloAmounts[realFillType]<=0 then
                g_currentMission.missionStats.farmSiloAmounts[realFillType]=0;
                self.fill=false;
              end; 									
						end;
						self.printText = true;
					else
						self.fill = false;
					end;
				end;
			end;
		end;			
	else
		self.fill = false;
	end;
	if not self.fill then
	  setEmittingState(self.siloParticleSystem, false);
	end;
end;

function superSiloTrigger:draw()
  if self.ShowHud then
    self.fruitHud:render();
    local s=g_i18n:getText(FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name);
    if string.find(s,".xml")~=nil then              
      s=FruitUtil.fruitIndexToDesc[self.fruits[self.actualfruit]].name;
    end;
    renderText(0.01, 0.01+g_currentMission.hudTipperOverlay.height+0.02,0.02,s);	
  end;
end;

function superSiloTrigger:superSiloTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter then
    if otherId ~= nil then
			self.trailerInTrigger = otherId;
			self.fruitTriggerId = triggerId;		
		end;		
	elseif onLeave then
		self.trailerInTrigger = 0;
		self.fruitTriggerId = 0;
		self.ShowHud = false;
	elseif onStay then
		if otherId ~= nil then
			self.trailerInTrigger = otherId;
			self.fruitTriggerId = triggerId;		
		end;
	end;	
end;

addModEventListener(superSiloTrigger);
