--
-- Multiplayer Event Script
--
-- M@D Author:  Heady
-- M@D date: 22.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

MPEvent = {};
MPEvent_mt = Class(MPEvent, Event);

InitEventClass(MPEvent, "MPEvent");

function MPEvent:emptyNew()
    local self = Event:new(MPEvent_mt);
    self.className="MPEvent";
    return self;
end;

function MPEvent:new(object)
    local self = MPEvent:emptyNew()
    self.object = object;
    return self;
end;

function MPEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.object.isTurnedOn = streamReadBool(streamId);
	self.object.pickup.isDown = streamReadBool(streamId);
	self.object.jointmove = streamReadBool(streamId);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(MPEvent:new(self.object), nil, connection, self.object);
	end;
end;

function MPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.object.isTurnedOn);
	streamWriteBool(streamId, self.object.pickup.isDown);
	streamWriteBool(streamId, self.object.jointmove);
end;