--
-- Deichsel
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Deichsel = {};

function Deichsel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Deichsel:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local deichsel = {};
    deichsel.name = getXMLString(xmlFile, "vehicle.deichsel#name");
    deichsel.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deichsel#upSpeedScale"), 1);
    deichsel.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deichsel#downSpeedScale"), -deichsel.openSpeedScale);
    if deichsel.name ~= nil then
        self.deichsel = deichsel;
    end;
	self.deichsel.active = false;
	
	
	self.jointmove = false;

	
end;

function Deichsel:delete()
end;

function Deichsel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Deichsel:keyEvent(unicode, sym, modifier, isDown)
end;

function Deichsel:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local deichselAnimTime = streamReadFloat32(streamId);
	
	if deichselAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.deichsel.name);
		local speed = 1;
		if currentTime > deichselAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.deichsel.name, speed, currentTime, true);
		self:setAnimationStopTime(self.deichsel.name, deichselAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function Deichsel:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.deichsel.name));
end;

function Deichsel:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local isDeichselActive = false;
		if InputBinding.isPressed(InputBinding.KRONEZX_DEICHSELUP) then
			self.jointmove = true;		
			isDeichselActive = true;
			if InputBinding.hasEvent(InputBinding.KRONEZX_DEICHSELUP) then
				self:playAnimation(self.deichsel.name, self.deichsel.openSpeedScale, self:getAnimationTime(self.deichsel.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.KRONEZX_DEICHSELDOWN) then
			self.jointmove = true;	
			isDeichselActive = true;	
			if InputBinding.hasEvent(InputBinding.KRONEZX_DEICHSELDOWN) then
				self:playAnimation(self.deichsel.name, self.deichsel.closeSpeedScale, self:getAnimationTime(self.deichsel.name)); 
			end;			
		end;
			
		if self.deichsel.active and not isDeichselActive then
			self:stopAnimation(self.deichsel.name);	
			self.jointmove = false;
		end;
		self.deichsel.active = isDeichselActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function Deichsel:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function Deichsel:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.KRONEZX_DEICHSELUP).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.KRONEZX_DEICHSELDOWN)..": Torro 5700 Knickdeichsel auf / ab");
	
end;

function Deichsel:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


