--
-- Maupu23
-- @poc@lypse
-- 
Maupu23 = {};

function Maupu23.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Maupu23:load(xmlFile)

    self.keys = {};
	self.keysName = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysName[inputName] = Utils.getNoNil(getXMLString(xmlFile, baseName.."#keyname"),"Touche ?");
        i = i+1;
    end;
   
  
    self.ridmode = 0;
    self.plane = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plane#index"));
    self.planeA = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.planeA#index"));
    self.suplane = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.suplane#index"));
    self.planeActive = true;       
    self.suplaneActive = true;    
   

    

    self.ridnorm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ridnorm#index"));
    setVisibility(self.ridnorm, true);
    self.ridbett = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ridbett#index"));
    setVisibility(self.ridbett, false);

     local rotationPartNodebequille = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bequille#index"));
    if rotationPartNodebequille ~= nil then
        self.rotationPartbequille = {};
        self.rotationPartbequille.node = rotationPartNodebequille;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbequille#minRot"));
        self.rotationPartbequille.minRot = {};
        self.rotationPartbequille.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbequille.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbequille.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille#maxRot"));
        self.rotationPartbequille.maxRot = {};
        self.rotationPartbequille.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbequille.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbequille.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbequille.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille#rotTime"), 2)*1000;
        self.rotationPartbequille.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille#touchRotLimit"), 10));
    end;
 
       local translationPartNodebequille1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bequille1#index"));
    if translationPartNodebequille1 ~= nil then
        self.translationPartbequille1 = {};
        self.translationPartbequille1.node = translationPartNodebequille1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#minTrans"));
        self.translationPartbequille1.minTrans = {};
        self.translationPartbequille1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bequille1#maxTrans"));
        self.translationPartbequille1.maxTrans = {};
        self.translationPartbequille1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartbequille1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartbequille1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartbequille1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#transTime"), 2)*1000;
        self.translationPartbequille1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bequille1#touchTransLimit"), 10);
    end;

 
      
   self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

        
  
        
	
	
     self.ridelleActive = true;
     self.ridbettActive = false;   
    	
end;

function Maupu23:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	
 
    local mode1 = Utils.getNoNil(getXMLBool(xmlFile, key.."#betterave"),false);
    local mode2 = Utils.getNoNil(getXMLBool(xmlFile, key.."#barre"),false);
    self.planeActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#bache"),false);
    if mode1 == true then
      self.ridmode = 1;
    elseif mode2 == true then
      self.ridmode = 2;
    end;
   
    if fillLevel ~= nil and fillType ~= nil then
        local fillTypeDesc = FruitUtil.fruitTypes[fillType];
        if fillTypeDesc ~= nil then
            self:setFillLevel(fillLevel, fillTypeDesc.index);
        end;
    end;	
   
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Maupu23:getSaveAttributesAndNodes(nodeIdent)
	-- save function
	
        local bettext='error';
	if self.ridmode == 1 then
		bettext='true';
	else
		bettext='false';
	end;
         local barretext='error';
	if self.ridmode == 2 then
		barretext='true';
	else
		barretext='false';
	end;
        local bachetext='error';
	if self.planeActive then
		bachetext='true';
	else
		bachetext='false';
	end;
       
    local attributes = 'betterave="'..bettext..'" barre="'..barretext..'" bache="'..bachetext..'"';

   return attributes, nil;
end;

function Maupu23:delete()
   
end;


function Maupu23:mouseEvent(posX, posY, isDown, isUp, button)
   
end;

function Maupu23:keyEvent(unicode, sym, modifier, isDown)
   
	

     if self.attacherVehicle ~= nil then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
  
     if isDown and sym == self.keys.support and self.fillLevel==0 then
		  self.ridmode = self.ridmode + 1;
                        if self.ridmode > 2 then
				self.ridmode = 0;
			end;
	end; 

    if isDown and sym == self.keys.bache then
		self.planeActive = not self.planeActive;
	end;

   

end;

function Maupu23:update(dt)

if self.ridmode == 0 then
 self.ridelleActive = true;
 self.ridbettActive = false;
 self.suplaneActive = false;
elseif self.ridmode == 1 then
 self.ridelleActive = false;
 self.ridbettActive = true;
 self.suplaneActive = false;
elseif self.ridmode == 2 then
 self.ridelleActive = true;
 self.ridbettActive = false;
 self.suplaneActive = true;
end;

if self.rotationPartbequille ~= nil then
		local x, y, z = getRotation(self.rotationPartbequille.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbequille.maxRot, self.rotationPartbequille.minRot, 3, self.rotationPartbequille.rotTime, dt, not self.rotationMaxbequille);
		setRotation(self.rotationPartbequille.node, unpack(newRot));        
   end;
   
   if self.translationPartbequille1 ~= nil then
		local x, y, z = getTranslation(self.translationPartbequille1.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartbequille1.maxTrans, self.translationPartbequille1.minTrans, 3, self.translationPartbequille1.transTime, dt, not self.translationMaxbequille1);
		setTranslation(self.translationPartbequille1.node, unpack(newTrans));
	end;
	 
 if self.attacherVehicle ~= nil then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;

 
  

  if not self.suplaneActive then
    self.planeActive = true;
  end;
  
   if self.barreActive then			
				local barres = self.barre;
				setVisibility(barres, self.barreActive);			
		    else
     			local barres = self.barre;
				setVisibility(barres, self.barreActive, false);			
	end;

   if self.suplaneActive then			
				local suplanes = self.suplane;
				setVisibility(suplanes, self.suplaneActive);			
		    else
     			local suplanes = self.suplane;
				setVisibility(suplanes, self.suplaneActive, false);			
	end;

    if self.ridelleActive then			
				local ridelles = self.ridnorm;
				setVisibility(ridelles, self.ridelleActive);			
		    else
     			local ridelles = self.ridnorm;
				setVisibility(ridelles, self.ridelleActive, false);			
	end;

     if self.ridbettActive then
                                local ridbetts = self.ridbett;
				setVisibility(ridbetts, self.ridbettActive);			
		    else
     			local ridbetts = self.ridbett;
				setVisibility(ridbetts, self.ridbettActive, false);			
	end;

    if self.planeActive then
				local plane = self.plane;
				setVisibility(plane);
				
				local planeA = self.planeA;
				setVisibility(planeA, false);

		else
				local plane = self.plane;
				setVisibility(plane, false);

				local planeA = self.planeA;
				setVisibility(planeA);

		end;	
     if self.visActive then			
				local viss = self.vis;
				setVisibility(viss, self.visActive);			
		    else
     			local viss = self.vis;
				setVisibility(viss, self.visActive, false);			
	end;

end;



function Maupu23:draw()
   if self.attacherVehicle then
        g_currentMission:addExtraPrintText("Touche R : Allumer/Eteindre le girophare");
      
    if self.suplaneActive then
        g_currentMission:addExtraPrintText("Touche J : Mettre/enlever la bache");
    end; 
        g_currentMission:addExtraPrintText("Touche X : Option ridelle");                       
	end; 
end;

function Trailer:onAttach(attacherVehicle)
self.translationMaxbequille1 = true;
end;

function Maupu23:onDetach()   
    self.translationMaxbequille1 = false;
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    
  
end;



