--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.80, 0.25, 0.02, " Numpad 0: Info Ein ");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.80, 0.25, 0.02, "Numpad 0: Info Aus");
		renderText(0.72, 0.78, 0.025, "- Belarus MTS 82 Turbo -");			
		renderText(0.72, 0.75, 0.02, "Taste Numpad 2: Warnblinker an / aus");
		renderText(0.72, 0.73, 0.02, "Taste Numpad 1: Blinker Links an / aus");
		renderText(0.72, 0.71, 0.02, "Taste Numpad 3: Blinker Rechts an / aus");
		renderText(0.72, 0.69, 0.02, "Taste Numpad 5: Heck Fenster auf/zu");
		renderText(0.72, 0.67, 0.02, "Taste Numpad 7: Tuer VL auf/zu");
		renderText(0.72, 0.65, 0.02, "Taste Numpad 9: Tuer VR auf/zu");
		renderText(0.72, 0.63, 0.02, "Taste Numpad 4: Fenster SL auf/zu");
		renderText(0.72, 0.61, 0.02, "Taste Numpad 6: Fenster SR auf/zu");
		renderText(0.72, 0.59, 0.02, "Taste 8: Zwillingsreifen an/aus");
		renderText(0.72, 0.57, 0.02, "Taste 9: Allrad an/aus");
		renderText(0.72, 0.55, 0.02, "Taste Numpad Enter: Motor an/aus");
		renderText(0.72, 0.53, 0.02, "Taste 0: Hupe");
		     renderText(0.72, 0.50, 0.025, "- Belarus MTS 82 Turbo -");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




