--
-- Specialisation for MB Trac 1600 Turbo
-- 
-- Author: Mofa-Killer, Face

MBTrac1600Turbo = {};

function MBTrac1600Turbo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MBTrac1600Turbo:load(xmlFile)

    self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));
	
	local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
	
	self.drehzahlnadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel#index"));
	self.tanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tanknadel#index"));
	self.drehzahlnadelLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadelLight#index"));
	self.tanknadelLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tanknadelLight#index"));
	self.tankicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankicon#index"));
	self.batterieicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batterieicon#index"));
	self.blinkericon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blinkericon#index"));
	
	self.controlPanel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanels.controlPanel1#index" ));
	self.controlPanel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanels.controlPanel2#index" ));
	
	self.updateJoint = false;
end;

function MBTrac1600Turbo:delete()
end;

function MBTrac1600Turbo:readStream(streamId, connection)
end;

function MBTrac1600Turbo:writeStream(streamId, connection)
end;

function MBTrac1600Turbo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MBTrac1600Turbo:keyEvent(unicode, sym, modifier, isDown)
end;

function MBTrac1600Turbo:update(dt)
    if self:getIsActive() then
		Cylindered.updateMovingPart(self, self.movingParts[1]);		
	end;
	
	if self.isMotorStarted then
        local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
        local rotateDrehzahlnadel = (((kmh / 30)*100) +10);
        local currentFuelPercentage = 0;
        local fuelWarnPercentage = 20;
        if self.fuelCapacity > 0 then
            currentFuelPercentage = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
        end;
        if currentFuelPercentage < fuelWarnPercentage then
            setVisibility(self.tankicon, true);
        else
            setVisibility(self.tankicon, false);
        end;
        setVisibility(self.batterieicon, false);
        local rotateTanknadel = ((currentFuelPercentage / 111) * 100);
        if self.currentLight > 0 then
            setVisibility(self.drehzahlnadel, false);
            setVisibility(self.tanknadel, false);
            setVisibility(self.drehzahlnadelLight, true);
            setVisibility(self.tanknadelLight, true);    
            setRotation(self.drehzahlnadelLight, 0, Utils.degToRad( - rotateDrehzahlnadel), 0);
            setRotation(self.tanknadelLight, 0, Utils.degToRad(rotateTanknadel), 0);
        else
            setVisibility(self.drehzahlnadel, true);
            setVisibility(self.tanknadel, true);
            setVisibility(self.drehzahlnadelLight, false);
            setVisibility(self.tanknadelLight, false);
            setRotation(self.drehzahlnadel, 0, Utils.degToRad( - rotateDrehzahlnadel), 0);
            setRotation(self.tanknadel, 0, Utils.degToRad(rotateTanknadel), 0);
        end;
    else
        setRotation(self.drehzahlnadel, 0, 0, 0);
        setRotation(self.tanknadel, 0, 0, 0);
        setRotation(self.drehzahlnadelLight, 0, 0, 0);
        setRotation(self.tanknadelLight, 0, 0, 0);
        setVisibility(self.batterieicon, true);
        setVisibility(self.tankicon, false);
    end;
    
    if self.invertedDrivingDirection == -1 then
        setTranslation(self.controlPanel1, -0.5, 0.75, -0.14);
        setRotation(self.controlPanel1, 70, -70, -70);
        setTranslation(self.controlPanel2, -0.27, 0.75, -0.137);
        setRotation(self.controlPanel2, 70, -70, -70);
    else
        setTranslation(self.controlPanel1, -0.727, 0.1, 1.066);
        setRotation(self.controlPanel1, 0, -200, 0);
        setTranslation(self.controlPanel2, -0.718, 0.4, 1.043);
        setRotation(self.controlPanel2, 0, -200, 0);
    end;	
end;

function MBTrac1600Turbo:updateTick(dt)
    if self:getIsActive() then
        if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);
		end;
		
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);
				self.finishWiper = true;
			end;
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
        for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
	
	if self.B3.wl or self.B3.dirLeft[1].a or self.B3.dirRight[1].a  then
		setVisibility(self.blinkericon,not self.B3.bls);
	else 
		setVisibility(self.blinkericon, false);
	end;
end;

function MBTrac1600Turbo:draw()
end;

function MBTrac1600Turbo:attachImplement(implement)

	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 2 then
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		end;
	end;
	
	self.updateJoint = true;
end;

function MBTrac1600Turbo:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 2 then
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	end;
end;

function MBTrac1600Turbo:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function MBTrac1600Turbo:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);
	end;
end;

function MBTrac1600Turbo:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);
	end;
	if self.isMotorStarted then
	   setVisibility(self.batterieicon, false);
	else
	   setVisibility(self.batterieicon, true);
	end;
end;
