--
-- BeaconsViewMapV2_WithDLC2
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

-- Credits: DECKER_MMIV

--
source(g_modsDirectory..'/BeaconsViewMapV2_2in1/beaconsViewV2/scripts/registerFruits.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_2in1/additionalMods/manureMod/manureMod.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_2in1/giantsLS11DLC2SDK/DLC2Bga.lua');
-- IMPORTANT!!            ^^^^^^^^^^^^^^^^^^^^^                                                         
-- IMPORTANT!! This folder-name MUST be EXACTLY the same as your archive-name, e.g. SampleModMap.ZIP
-- IMPORTANT!!  
--


BeaconsViewMapV2_WithDLC2 = {}

local BeaconsViewMapV2_WithDLC2_mt = Class(BeaconsViewMapV2_WithDLC2, Mission00);

function BeaconsViewMapV2_WithDLC2:new(baseDirectory, customMt)
--
  RegisterFruits(baseDirectory);
--    
    local mt = customMt;
    if mt == nil then
        mt = BeaconsViewMapV2_WithDLC2_mt;
    end;
    local self = BeaconsViewMapV2_WithDLC2:superClass():new(baseDirectory, mt);
    return self;
end;

function BeaconsViewMapV2_WithDLC2:delete()
    BeaconsViewMapV2_WithDLC2:superClass().delete(self);
end;

function BeaconsViewMapV2_WithDLC2:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    -- load the map
    self:loadMap(Utils.getFilename("BeaconsViewMapV2.i3d", self.baseDirectory));

    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));

    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));

    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));

    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map_WithDLC2.png", self.baseDirectory));

    BeaconsViewMapV2_WithDLC2:superClass().load(self);
end
function BeaconsViewMapV2_WithDLC2:loadFinished()
    BeaconsViewMapV2_WithDLC2:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function BeaconsViewMapV2_WithDLC2:mouseEvent(posX, posY, isDown, isUp, button)
    BeaconsViewMapV2_WithDLC2:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BeaconsViewMapV2_WithDLC2:keyEvent(unicode, sym, modifier, isDown)
    BeaconsViewMapV2_WithDLC2:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BeaconsViewMapV2_WithDLC2:update(dt)
    BeaconsViewMapV2_WithDLC2:superClass().update(self, dt);
end;

function BeaconsViewMapV2_WithDLC2:draw()
    BeaconsViewMapV2_WithDLC2:superClass().draw(self);
end;

