--
-- BeaconsViewMapV2_NoDLC2
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- 
function DLC2BgaOnCreate(id)
    -- Remove the DLC2-BGA scenegraph-node and everything it contains.
    delete(id);
end;
g_onCreateUtil.addOnCreateFunction("dlc2_Bga_onCreate", DLC2BgaOnCreate);

function DLC2BunkerSiloOnCreate(id)
end;
g_onCreateUtil.addOnCreateFunction("dlc2_BunkerSilo_onCreate", DLC2BunkerSiloOnCreate);
--

--
source(g_modsDirectory..'/BeaconsViewMapV2_2in1/beaconsViewV2/scripts/registerFruits.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_2in1/additionalMods/manureMod/manureMod.lua');
--

BeaconsViewMapV2_NoDLC2 = {}

local BeaconsViewMapV2_NoDLC2_mt = Class(BeaconsViewMapV2_NoDLC2, Mission00);

function BeaconsViewMapV2_NoDLC2:new(baseDirectory, customMt)
--
  RegisterFruits(baseDirectory);
--    
    local mt = customMt;
    if mt == nil then
        mt = BeaconsViewMapV2_NoDLC2_mt;
    end;
    local self = BeaconsViewMapV2_NoDLC2:superClass():new(baseDirectory, mt);
    return self;
end;

function BeaconsViewMapV2_NoDLC2:delete()
    BeaconsViewMapV2_NoDLC2:superClass().delete(self);
end;

function BeaconsViewMapV2_NoDLC2:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    -- load the map
    self:loadMap(Utils.getFilename("BeaconsViewMapV2.i3d", self.baseDirectory));

    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));

    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));

    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));

    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map_NoDLC2.png", self.baseDirectory));

    BeaconsViewMapV2_NoDLC2:superClass().load(self);
end
function BeaconsViewMapV2_NoDLC2:loadFinished()
    BeaconsViewMapV2_NoDLC2:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function BeaconsViewMapV2_NoDLC2:mouseEvent(posX, posY, isDown, isUp, button)
    BeaconsViewMapV2_NoDLC2:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BeaconsViewMapV2_NoDLC2:keyEvent(unicode, sym, modifier, isDown)
    BeaconsViewMapV2_NoDLC2:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BeaconsViewMapV2_NoDLC2:update(dt)
    BeaconsViewMapV2_NoDLC2:superClass().update(self, dt);
end;

function BeaconsViewMapV2_NoDLC2:draw()
    BeaconsViewMapV2_NoDLC2:superClass().draw(self);
end;

