--
--
--


-- Register fruits
function RegisterFruits(modDir)
  local fruitList = {};

  -- Notes:
  -- "type" is not accurate. It were an attempt to group the fruits, so they may be easier selected at silos/sell-points.
  -- "fruitName" must be the same as in the FoliageSubLayers.
  table.insert(fruitList, {type="root"              ,fruitName="potato"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=1 ,pricePerLiter=0.4  ,literPerQm=0.8 ,seedUsagePerQm=0.02    ,seedPricePerLiter=0.1} );
  table.insert(fruitList, {type="root"              ,fruitName="sugarbeet"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=3 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
  
  --
  -- Can not seed or harvest! Only for transport!
  -- Make sure that 'allowsSeeding' is FALSE. If not, they would also show up in the sowing-machine!
  table.insert(fruitList, {type="none"              ,fruitName="manure"         ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none"              ,fruitName="liquidManure"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none"              ,fruitName="fertilizer"     ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none"              ,fruitName="pesticide"      ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none"              ,fruitName="milk"           ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none"              ,fruitName="water"          ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  -- WeedMod                
  table.insert(fruitList, {type="none"              ,fruitName="weed"           ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  -- ManureMod
  table.insert(fruitList, {type="none" ,noIcon=true ,fruitName="manureSolid"    ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  table.insert(fruitList, {type="none" ,noIcon=true ,fruitName="manureLiquid"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
  

  --
  print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
  for i=1, table.getn(fruitList) do
    local hudFile = nil; 
    if (fruitList[i].noIcon == nil) then
      local filename = "beaconsViewV2/images/".. fruitList[i].fruitName .."Hud.png";
      hudFile = Utils.getFilename(filename, modDir);
    end;
    FruitUtil.registerFruitType(
         fruitList[i].fruitName                 -- string fruitName
        ,fruitList[i].needsSeeding              -- bool needsSeeding    (ARGH! I spent 3-4 days trying to find out why the new crop autogrows. Then I noticed an 's' were missing, so 'needSeeding' returned nil.)
        ,fruitList[i].allowsSeeding             -- bool allowsSeeding
        ,fruitList[i].hasStraw                  -- bool hasStraw
        ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
        ,fruitList[i].pricePerLiter             -- float pricePerLiter
        ,fruitList[i].literPerQm                -- float literPerQm
        ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
        ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
        ,hudFile                                -- file hudFruitOverlayFilename
    );
  end;
end;
--RegisterFruits();

--
--
--
--local origSowingMachineLoad = SowingMachine.load;
--SowingMachine.load = function(self, xmlFile)
--  if origSowingMachineLoad ~= nil then
--    origSowingMachineLoad(self, xmlFile);
--  end;
function RegisterFruitsSowingMachineLoad(self, xmlFile)
  --
  local msg = "Info. Added seeds to '".. Utils.getNoNil(self.name, "SowingMachine") .."': ";
  self.seeds = {};
  for k, fruitType in pairs(FruitUtil.fruitTypes) do
    -- Check if FruitType have a FoliageSubLayer-/TerrainId.
    local terrainId = 0;
    if g_currentMission.fruits[fruitType.index] ~= nil then
      terrainId = g_currentMission.fruits[fruitType.index].id;
    end;
    -- Only add FruitType if its allowed to be seeded, AND have a FoliageSubLayer-/TerrainId.
    if fruitType.allowsSeeding and terrainId > 0 then
      table.insert(self.seeds, fruitType.index);
      msg = msg .. FruitUtil.fruitIndexToDesc[ fruitType.index ].name .." ";
    end;
  end;
  print(msg);
  -- Sort the seedable fruits by generic-name.
  table.sort(self.seeds, function(l,r) return (FruitUtil.fruitIndexToDesc[l].name < FruitUtil.fruitIndexToDesc[r].name); end);
end;
SowingMachine.load = Utils.appendedFunction(SowingMachine.load, RegisterFruitsSowingMachineLoad);

print("Script loaded: RegisterFruits.LUA");