--
-- Manure Mod
--
-- Author: HmcrE
-- Date:   27-04-2011
--

-- 'manureSolid' & 'manureLiquid' is registered in registerFruits.LUA

--FruitUtil.registerFruitType("manureSolid",  false, false, true, 1, 100, 2, 1, 1, nil)
--FruitUtil.registerFruitType("manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil)

----

ManureMod = {}

ManureMod.load = function(self, xmlFile)
  self.ManureMod_active = self.fillTypes[Fillable.FILLTYPE_MANURE]       ~= nil or
                          self.fillTypes[Fillable.FILLTYPE_LIQUIDMANURE] ~= nil;
end;

ManureMod.updateTick = function(self, dt)
  if self.isTurnedOn then
    if self.ManureMod_active and self.fillLevel > 0 and (self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE or self.currentFillType == Fillable.FILLTYPE_MANURE) then
      -- Add manure
      local manureType = FruitUtil.FRUITTYPE_MANURELIQUID;
      local value = 0.6;
      if (self.currentFillType == Fillable.FILLTYPE_MANURE) then
        manureType = FruitUtil.FRUITTYPE_MANURESOLID;
        value = 3;
      end;
      for i = 1, table.getn(self.cuttingAreas) do
        local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
        local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
        local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
        local value = math.min(value, g_currentMission.maxWindrowValue);
        Utils.updateFruitWindrowArea(manureType, x, z, x1, z1, x2, z2, value, true, false)
        -- TODO - Multiplayer support?
      end;
    end;
  end;
end;

Sprayer.load        = Utils.appendedFunction(Sprayer.load,       ManureMod.load);
Sprayer.updateTick  = Utils.appendedFunction(Sprayer.updateTick, ManureMod.updateTick);

----

ManureMod.updateTerrainArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)
  -- Remove manure
  Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURESOLID,  startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, true, false)
  Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURELIQUID, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, true, false)
end;

Utils.updateCultivatorArea = Utils.appendedFunction(Utils.updateCultivatorArea, ManureMod.updateTerrainArea);
Utils.updatePloughArea     = Utils.appendedFunction(Utils.updatePloughArea,     ManureMod.updateTerrainArea);

print("Script loaded: ManureMod.LUA");