--
-- BeaconsViewMapV2
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

--
source(g_modsDirectory..'/BeaconsViewMapV2_DLC2/beaconsViewV2/scripts/registerFruits.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_DLC2/additionalMods/manureMod/manureMod.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_DLC2/additionalMods/weed/weed.lua');
--


BeaconsViewMapV2 = {}

local BeaconsViewMapV2_mt = Class(BeaconsViewMapV2, Mission00);

function BeaconsViewMapV2:new(baseDirectory, customMt)
--
  RegisterFruits(baseDirectory);
--    
    local mt = customMt;
    if mt == nil then
        mt = BeaconsViewMapV2_mt;
    end;
    local self = BeaconsViewMapV2:superClass():new(baseDirectory, mt);
    return self;
end;

function BeaconsViewMapV2:delete()
    BeaconsViewMapV2:superClass().delete(self);
end;

function BeaconsViewMapV2:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    -- load the map
    self:loadMap(Utils.getFilename("BeaconsViewMapV2.i3d", self.baseDirectory));

    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));

    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));

    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));

    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

    BeaconsViewMapV2:superClass().load(self);
end
function BeaconsViewMapV2:loadFinished()
    BeaconsViewMapV2:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function BeaconsViewMapV2:mouseEvent(posX, posY, isDown, isUp, button)
    BeaconsViewMapV2:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BeaconsViewMapV2:keyEvent(unicode, sym, modifier, isDown)
    BeaconsViewMapV2:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BeaconsViewMapV2:update(dt)
    BeaconsViewMapV2:superClass().update(self, dt);
end;

function BeaconsViewMapV2:draw()
    BeaconsViewMapV2:superClass().draw(self);
end;

