--
-- BeaconsViewMapV2NoBGA
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

--
source(g_modsDirectory..'/BeaconsViewMapV2_NO_DLC2_BGA/beaconsViewV2/scripts/registerFruits.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_NO_DLC2_BGA/additionalMods/manureMod/manureMod.lua');
source(g_modsDirectory..'/BeaconsViewMapV2_NO_DLC2_BGA/additionalMods/weed/weed.lua');
--


BeaconsViewMapV2NoBGA = {}

local BeaconsViewMapV2NoBGA_mt = Class(BeaconsViewMapV2NoBGA, Mission00);

function BeaconsViewMapV2NoBGA:new(baseDirectory, customMt)
--
  RegisterFruits(baseDirectory);
--
    local mt = customMt;
    if mt == nil then
        mt = BeaconsViewMapV2NoBGA_mt;
    end;
    local self = BeaconsViewMapV2NoBGA:superClass():new(baseDirectory, mt);
    return self;
end;

function BeaconsViewMapV2NoBGA:delete()
    BeaconsViewMapV2NoBGA:superClass().delete(self);
end;

function BeaconsViewMapV2NoBGA:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    -- load the map
    self:loadMap(Utils.getFilename("BeaconsViewMapV2NoBGA.i3d", self.baseDirectory));

    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));

    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));

    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));

    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));

    BeaconsViewMapV2NoBGA:superClass().load(self);
end
function BeaconsViewMapV2NoBGA:loadFinished()
    BeaconsViewMapV2NoBGA:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function BeaconsViewMapV2NoBGA:mouseEvent(posX, posY, isDown, isUp, button)
    BeaconsViewMapV2NoBGA:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BeaconsViewMapV2NoBGA:keyEvent(unicode, sym, modifier, isDown)
    BeaconsViewMapV2NoBGA:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BeaconsViewMapV2NoBGA:update(dt)
    BeaconsViewMapV2NoBGA:superClass().update(self, dt);
end;

function BeaconsViewMapV2NoBGA:draw()
    BeaconsViewMapV2NoBGA:superClass().draw(self);
end;

