--
-- Crate AutoUnload
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2011-11-15
--
-- @brief   When object is within a TipTrigger, it will automatically activate unloading.
--

Crate = {}

--function Crate.log(self, msg)
--  print(string.format("%7ums Crate(%s) ", g_currentMission.time, tostring(self)) .. msg);
--end;

function Crate.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;    

function Crate:load(xmlFile)
  self.inTrigger = false;
end;

function Crate:delete()
end;

function Crate:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Crate:keyEvent(unicode, sym, modifier, isDown)
end;

--function Crate:readStream(streamId, connection)
--end;

--function Crate:writeStream(streamId, connection)
--end;

function Crate:update(dt)
  if self.isServer then   --and self:getIsActive() then
    if not self.inTrigger then 
      if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.fillLevel > 0 and g_currentMission.trailerTipTriggers[self] ~= nil then
        for _,tipTrigger in pairs(g_currentMission.trailerTipTriggers[self]) do
          if (g_currentMission:getIsTrailerInTipRange(self, tipTrigger)) then
            if (tipTrigger.acceptedFruitTypes[FruitUtil.fillTypeToFruitType[self.currentFillType]]) then
              --Crate.log(self, "Opening");
              self.inTrigger = true;
              self:toggleTipState(tipTrigger);
            end;
            break;
          end;
        end;
      end;
    else
      if g_currentMission.trailerTipTriggers[self] == nil then
        --Crate.log(self, "Closing");
        self.inTrigger = false;
        if self.fillLevel > 0 then
          self:toggleTipState(nil);
        end;
      end;
    end;
  end;
end;

--function Crate:updateTick(dt)
--end;

function Crate:draw()
end;  

--print("Crate.LUA loaded");
