-- Hauswirth24
-- Bayn TSF3
-- Big thanks to guimchevalier for his script "Pince.lua"
-- 03-09-09
--Automated Load/Unload added by Nibmeister


Hauswirth24 = {};

function Hauswirth24.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Hauswirth24:load(xmlFile)	
	
	self.numAttachers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers#count"), 0);
	self.Attacher = {};
	self.attacherLevel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Attachers#index"));
	self.ulMode = 1;
	--[[ ulMode is unloading direction, used as index for table below. 
		 Table Values are, per mode as index: [1]str:label [2]boolean:use default code [3] optional table{int:offets  x,y,z}
		 Label and boolean values required, offsets required if 2 is true (if you're using the default unloading code)
		 If 2 is false, any needed values can be filled into values 3+, then use the section marked in the "ObjectDetachHauswirth24" function below. --]]
	self.ulRef = {{"right",false,{0,0,-5}},{"left",false,{0,0,5}},{"back",false,{15,0,0}},{"custom",true,"This is a custom parameter ;-)"}};	
	for i=1, self.numAttachers do
	 self.Attacher[i] = {};
	 local partnamei = string.format("vehicle.Attachers.objectAttacher".."%d",i);
	 self.Attacher[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
	 setRigidBodyType(self.Attacher[i].coll,"none")
	 self.Attacher[i].attachedObject = nil;
	 self.Attacher[i].objectInRange = nil;
	end;
end;

function Hauswirth24:getSaveAttributesAndNodes(nodeIdent)
    for i=1, self.numAttachers do
        ObjectDetachHauswirth24(self,i)
    end;
    
   return nil, nil;
end;


function Hauswirth24:delete()
			for i=1, self.numAttachers do
			ObjectDetachHauswirth24(self,i)
			end;
end;

function Hauswirth24:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hauswirth24:keyEvent(unicode, sym, modifier, isDown)
  
  if isDown and sym == Input.KEY_u then
    if self.ulMode == 4 then
      self.ulMode = 0
    end;
    self.ulMode = self.ulMode + 1
  end;

end;

function Hauswirth24:update(dt)
 
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.HAUSWIRTH24DETACH) then
			-- dcrochage
			for i=1, self.numAttachers do
			ObjectDetachHauswirth24(self,i)
			end;
		end;

		if InputBinding.isPressed(InputBinding.HAUSWIRTH24ATTACH) then
			-- dtection ballot
			for i=1, self.numAttachers do
				nearest, index = ObjectInRangeHauswirth24(self,i);
				self.Attacher[i].objectInRange = nearest;
				-- accrochage
				ObjectAttachHauswirth24(self,i)
			end;

		end;
	end;
end;

function Hauswirth24:draw()
	if self.attacherVehicle ~= nil then
		g_currentMission:addExtraPrintText(string.format("Key %s/%s: Attach/Detach bales", InputBinding.getButtonKeyName(InputBinding.HAUSWIRTH24ATTACH), InputBinding.getButtonKeyName(InputBinding.HAUSWIRTH24DETACH)));
    g_currentMission:addExtraPrintText(string.format("Key U: Switch Unload Direction - Currently using (%s)", self.ulRef[self.ulMode][1]));
  end;
end;

function ObjectInRangeHauswirth24(self,k)
	local nearestObject
	local itemNode
	local index 
	local nearestDistance = 100;
	local objectCopy = self.Attacher[k].object;	
	local px, py, pz = getWorldTranslation(objectCopy);
	for i=1, table.getn(g_currentMission.itemsToSave) do
	    itemNode = g_currentMission.itemsToSave[i].node;
	    if getParent(g_currentMission.itemsToSave[i].node) == getRootNode() then
			if getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale") then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					index = i
					nearestObject = itemNode
					nearestDistance = distance
					
				end;
			end;
		end;
	end;
	return nearestObject, index
end;

function ObjectAttachHauswirth24(self,k)
	if self.Attacher[k].objectInRange ~= nil then
		if self.Attacher[k].attachedObject == nil then
			setRigidBodyType(self.Attacher[k].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[k].objectInRange);		
			link(self.Attacher[k].object,self.Attacher[k].objectInRange);
			setRotation(self.Attacher[k].objectInRange, 0,0,0);
			setTranslation(self.Attacher[k].objectInRange, 0,0,0)
			self.Attacher[k].attachedObject = self.Attacher[k].objectInRange;
			self.Attacher[k].objectInRange = nil;
		end;
	end;
end;


function ObjectDetachHauswirth24(self,k)
	if self.Attacher[k].attachedObject ~= nil then			
		if not self.ulRef[self.ulMode][2] then
			local x,y,z = getWorldTranslation(self.Attacher[k].attachedObject)
			local rx,ry,rz = getWorldRotation(self.Attacher[k].attachedObject)
			local nx,ny,nz = getWorldTranslation(self.attacherLevel);
			local tx,ty,tz = unpack(self.ulRef[self.ulMode][3]);
			local x = x + tx
			local y = y + ty
			local z = z + tz
			local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local relHeight = ny - tH
			local root = getRootNode()
			setRigidBodyType(self.Attacher[k].attachedObject,"Dynamic")
			setTranslation(self.Attacher[k].attachedObject,x,(y - relHeight),z)
			setRotation(self.Attacher[k].attachedObject,rx,ry,rz)
			link(root,self.Attacher[k].attachedObject)
			self.Attacher[k].attachedObject = nil;
		else
			---[[ --Custom unloading chunk.  If you break the game with this and can't fix it, remove a dash from this line to deactivate it.
			print(self.ulRef[self.ulMode][3]);
			-- End of custom unloading chunk. Just leave this line alone.]]
		end;
	end;
end;