

Arbeitslicht_hi_vo_MF = {};

function Arbeitslicht_hi_vo_MF.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Arbeitslicht_hi_vo_MF:load(xmlFile)
    
     self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.worklightsActive = false;

    self.numWorklights_vo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights_vo#count"), 0);
    self.worklights_vo = {};
    for i=1, self.numWorklights_vo do
        local worklight_vonamei = string.format("vehicle.worklights_vo.worklight_vo" .. "%d", i);
        self.worklights_vo[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklight_vonamei .. "#index"));
        setVisibility(self.worklights_vo[i], false);
    end;	
	
	self.worklights_voActive = false;	
end;

function Arbeitslicht_hi_vo_MF:delete()
end;

function Arbeitslicht_hi_vo_MF:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Arbeitslicht_hi_vo_MF:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_7 then
		self.worklightsActive = not self.worklightsActive;
	end;
	if isDown and sym == Input.KEY_8 then
		self.worklights_voActive = not self.worklights_voActive;
	end;
end;

function Arbeitslicht_hi_vo_MF:update(dt)

   
   if self.isEntered then
   if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
	if self.isEntered then
   if self.worklightsActive_vo then
		for i=1, self.numWorklights_vo do
			local worklight_vo = self.worklights_vo[i];
			setVisibility(worklight_vo, self.worklights_voActive);
		end;
	else
		for i=1, self.numWorklights_vo do
			local worklight_vo = self.worklights_vo[i];
			setVisibility(worklight_vo, self.worklights_voActive, false);
		end;
	end;
	end;
end;


function Arbeitslicht_hi_vo_MF:onLeave()

	
	self.worklightsActive = false;
    self.worklights_voActive = false;
end;


function Arbeitslicht_hi_vo_MF:draw()

        renderText(0.780, 0.22, 0.022, "Taste 7: AL Seite an/aus");
        renderText(0.780, 0.245, 0.022, "Taste 8: AL Vorn an/aus");

end;