BC_5070CreateBaleEvent = {};
BC_5070CreateBaleEvent_mt = Class(BC_5070CreateBaleEvent, Event);

InitEventClass(BC_5070CreateBaleEvent, "BC_5070CreateBaleEvent");

function  BC_5070CreateBaleEvent:emptyNew()
	local self = Event:new(BC_5070CreateBaleEvent_mt);
	self.className="BC_5070CreateBaleEvent";
	return self;
end;

function BC_5070CreateBaleEvent:new(object, usedFruitType, baleTime)
	local self = BC_5070CreateBaleEvent:emptyNew()
	self.usedFruitType = usedFruitType;
	self.baleTime = baleTime;
	self.object = object;
	return self;
end;

function BC_5070CreateBaleEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.usedFruitType = streamReadInt8(streamId);
	self.baleTime = streamReadFloat32(streamId);
	self:run(connection);
end;

function BC_5070CreateBaleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.usedFruitType);
	streamWriteFloat32(streamId, self.baleTime);
end;

function BC_5070CreateBaleEvent:run(connection)
	--print("creating bale");
	BC_5070.createBale(self.object, self.usedFruitType);
	BC_5070.setBaleTime(self.object, table.getn(self.object.bales), self.baleTime);
end;

BC_5070SetBaleTimeEvent = {};
BC_5070SetBaleTimeEvent_mt = Class( BC_5070SetBaleTimeEvent, Event);

InitEventClass(BC_5070SetBaleTimeEvent, "BC_5070SetBaleTimeEvent");

function BC_5070SetBaleTimeEvent:emptyNew()
	local self = Event:new(BC_5070SetBaleTimeEvent_mt);
	self.className=" BC_5070SetBaleTimeEvent";
	return self;
end;

function BC_5070SetBaleTimeEvent:new(object, bale, baleTime)
	local self =  BC_5070SetBaleTimeEvent:emptyNew()
	self.bale = bale;
	self.baleTime = baleTime;
	self.object = object;
	return self;
end;

function BC_5070SetBaleTimeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.bale = streamReadInt32(streamId);
	self.baleTime = streamReadFloat32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function BC_5070SetBaleTimeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.bale);
	streamWriteFloat32(streamId, self.baleTime);
end;

function BC_5070SetBaleTimeEvent:run(connection)
	BC_5070.setBaleTime(self.object, self.bale, self.baleTime);
end;

-- Mechanism panel event
SetMechanismPanelEvent = {};
SetMechanismPanelEvent_mt = Class(SetMechanismPanelEvent, Event);

InitEventClass(SetMechanismPanelEvent, "SetMechanismPanelEvent");

function SetMechanismPanelEvent:emptyNew()
    local self = Event:new(SetMechanismPanelEvent_mt);
    self.className="SetMechanismPanelEvent";
    return self;
end;

function SetMechanismPanelEvent:new(vehicle, isMechanismPanelState)
    local self = SetMechanismPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isMechanismPanelState = isMechanismPanelState;
    return self;
end;

function SetMechanismPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isMechanismPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetMechanismPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isMechanismPanelState);
end;

function SetMechanismPanelEvent:run(connection)   
	self.vehicle:setMechanismPanel(self.isMechanismPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetMechanismPanelEvent:new(self.vehicle, self.isMechanismPanelState), nil, connection, self.vehicle);
    end;
end;

function SetMechanismPanelEvent.sendEvent(vehicle, isMechanismPanelState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetMechanismPanelEvent:new(vehicle, isMechanismPanelState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetMechanismPanelEvent:new(vehicle, isMechanismPanelState));
		end;
	end;
end;

-- Rope panel event
SetRopePanelEvent = {};
SetRopePanelEvent_mt = Class(SetRopePanelEvent, Event);

InitEventClass(SetRopePanelEvent, "SetRopePanelEvent");

function SetRopePanelEvent:emptyNew()
    local self = Event:new(SetRopePanelEvent_mt);
    self.className="SetRopePanelEvent";
    return self;
end;

function SetRopePanelEvent:new(vehicle, isRopePanelState)
    local self = SetRopePanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRopePanelState = isRopePanelState;
    return self;
end;

function SetRopePanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRopePanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRopePanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRopePanelState);
end;

function SetRopePanelEvent:run(connection)   
	self.vehicle:setRopePanel(self.isRopePanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRopePanelEvent:new(self.vehicle, self.isRopePanelState), nil, connection, self.vehicle);
    end;
end;

function SetRopePanelEvent.sendEvent(vehicle, isRopePanelState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRopePanelEvent:new(vehicle, isRopePanelState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRopePanelEvent:new(vehicle, isRopePanelState));
		end;
	end;
end;

-- BackFlap event --
SetBackFlapEvent = {};
SetBackFlapEvent_mt = Class(SetBackFlapEvent, Event);

InitEventClass(SetBackFlapEvent, "SetBackFlapEvent");

function SetBackFlapEvent:emptyNew()
    local self = Event:new(SetBackFlapEvent_mt);
    self.className="SetBackFlapEvent";
    return self;
end;

function SetBackFlapEvent:new(vehicle, isBackFlap)
    local self = SetBackFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.isBackFlap = isBackFlap;
    return self;
end;

function SetBackFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBackFlap = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBackFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isBackFlap);
end;

function SetBackFlapEvent:run(connection)   
	self.vehicle:setBackFlap(self.isBackFlap, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBackFlapEvent:new(self.vehicle, self.isBackFlap), nil, connection, self.vehicle);
    end;
end;

function SetBackFlapEvent.sendEvent(vehicle, isBackFlap, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBackFlapEvent:new(vehicle, isBackFlap), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBackFlapEvent:new(vehicle, isBackFlap));
		end;
	end;
end;

-- Reset counter event --
ResetBaleCounterEvent = {};
ResetBaleCounterEvent_mt = Class(ResetBaleCounterEvent, Event);

InitEventClass(ResetBaleCounterEvent, "ResetBaleCounterEvent");

function ResetBaleCounterEvent:emptyNew()
    local self = Event:new(ResetBaleCounterEvent_mt);
    self.className="ResetBaleCounterEvent";
    return self;
end;

function ResetBaleCounterEvent:new(vehicle, resetCounter)
    local self = ResetBaleCounterEvent:emptyNew()
    self.vehicle = vehicle;
	self.resetCounter = resetCounter;
    return self;
end;

function ResetBaleCounterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.resetCounter = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ResetBaleCounterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.resetCounter);
end;

function ResetBaleCounterEvent:run(connection)   
	self.vehicle:resetBaleCounter(self.resetCounter, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ResetBaleCounterEvent:new(self.vehicle, self.resetCounter), nil, connection, self.vehicle);
    end;
end;

function ResetBaleCounterEvent.sendEvent(vehicle, resetCounter, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ResetBaleCounterEvent:new(vehicle, resetCounter), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ResetBaleCounterEvent:new(vehicle, resetCounter));
		end;
	end;
end;

SetHasRopesEvent = {};
SetHasRopesEvent_mt = Class(SetHasRopesEvent, Event);

InitEventClass(SetHasRopesEvent, "SetHasRopesEvent");

function SetHasRopesEvent:emptyNew()
    local self = Event:new(SetHasRopesEvent_mt);
    self.className="SetHasRopesEvent";
    return self;
end;

function SetHasRopesEvent:new(vehicle, isLoadedWithRopes)
    local self = SetHasRopesEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoadedWithRopes = isLoadedWithRopes;
    return self;
end;

function SetHasRopesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoadedWithRopes = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetHasRopesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoadedWithRopes);
end;

function SetHasRopesEvent:run(connection)   
	self.vehicle:setHasRopes(self.isLoadedWithRopes, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetHasRopesEvent:new(self.vehicle, self.isLoadedWithRopes), nil, connection, self.vehicle);
    end;
end;

function SetHasRopesEvent.sendEvent(vehicle, isLoadedWithRopes, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes));
		end;
	end;
end;

MoveBalesOutEvent = {};
MoveBalesOutEvent_mt = Class(MoveBalesOutEvent, Event);

InitEventClass(MoveBalesOutEvent, "MoveBalesOutEvent");

function MoveBalesOutEvent:emptyNew()
    local self = Event:new(MoveBalesOutEvent_mt);
    self.className="MoveBalesOutEvent";
    return self;
end;

function MoveBalesOutEvent:new(vehicle, moveBales)
    local self = MoveBalesOutEvent:emptyNew()
    self.vehicle = vehicle;
	self.moveBales = moveBales;
    return self;
end;

function MoveBalesOutEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.moveBales = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MoveBalesOutEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.moveBales);
end;

function MoveBalesOutEvent:run(connection)   
	self.vehicle:doMoveBalesOut(self.moveBales, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MoveBalesOutEvent:new(self.vehicle, self.moveBales), nil, connection, self.vehicle);
    end;
end;

function MoveBalesOutEvent.sendEvent(vehicle, moveBales, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MoveBalesOutEvent:new(vehicle, moveBales), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MoveBalesOutEvent:new(vehicle, moveBales));
		end;
	end;
end;