--
-- aussieFarms
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

aussieFarms = {}

local aussieFarms_mt = Class(aussieFarms, Mission00);

function aussieFarms:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = aussieFarms_mt;
    end;
    local self = aussieFarms:superClass():new(baseDirectory, mt);
    return self;
end;

function aussieFarms:delete()
    aussieFarms:superClass().delete(self);
end;

function aussieFarms:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    --self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    --self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    aussieFarms:superClass().load(self);
end
function aussieFarms:loadFinished()
    aussieFarms:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function aussieFarms:mouseEvent(posX, posY, isDown, isUp, button)
    aussieFarms:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function aussieFarms:keyEvent(unicode, sym, modifier, isDown)
    aussieFarms:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function aussieFarms:update(dt)
    aussieFarms:superClass().update(self, dt);
end;

function aussieFarms:draw()
    aussieFarms:superClass().draw(self);
end;
