--
-- PeterJ (Ls_uk Modteam)
-- 15.09.2011
--
-- > www.LS-UK.info/modteam

loader2Attacher = {};

function loader2Attacher.prerequisitesPresent(specializations)
    return true;
end;

function loader2Attacher:load(xmlFile)

	local jointTypeStr = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#jointType");
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		
		if jointType == nil then
			Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;
		
		if jointType ~= nil then
			self.attacherJoints[1].jointType = jointType;				
		end;
	end;

	self.attacherVehicleCopy = nil;
	
end;

function loader2Attacher:delete()
end;

function loader2Attacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function loader2Attacher:keyEvent(unicode, sym, modifier, isDown)
end;

function loader2Attacher:update(dt)	
end;

function loader2Attacher:draw()
end;

function loader2Attacher:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
    for k,v in pairs(self.attachedImplements) do	
		if v.object.onloader2AttacherAttach ~= nil then
            v.object:onloader2AttacherAttach(attacherVehicle);
		end;
    end;
end;

function loader2Attacher:onDetach()
	self.attacherVehicleCopy = nil;
    for k,v in pairs(self.attachedImplements) do
		if v.object.onloader2AttacherDetach ~= nil then
            v.object:onloader2AttacherDetach(attacherVehicle);
		end;
    end;
end;

function loader2Attacher:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;