-- script for the AnimalMod
-- idea by jengske_BE
-- example script by Xentro
-- this is the triggerScript for selling the buyable animals
-- onCreate type scriptcallback = animalModTrigger.onCreate

animalModTrigger = {};

local animalModTrigger_mt = Class(animalModTrigger, Object);

function onCreate(self, id)
    local instance = animalModTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
end;

function animalModTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, animalModTrigger_mt);
    self.className = "animalModTrigger";
    self.triggerId = 0;
	
    return self;
end;
function animalModTrigger:load(id)
    
    self.triggerId = id;
    addTrigger(id, "triggerCallback", self);
	self.isEnabled = true;
	
	self.acceptedAnimals = {}
	local animalTable = getUserAttribute(id, "animalTypes");
	if animalTable ~= nil then
		local types = Utils.splitString(" ", animalTable);
		
		for k,v in pairs(types) do
			if v ~= nil then
				table.insert(self.acceptedAnimals, {animal = v});
			end;
		end;
	end;
end;

function animalModTrigger:delete()
    removeTrigger(self.triggerId);
end;

function animalModTrigger:update(dt)
end;

function animalModTrigger:updateTick(dt)
end;

function animalModTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled then
		if onEnter then
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			if vehicle ~= nil and vehicle.animal ~= nil then
				for k,v in pairs(self.acceptedAnimals) do
					if v ~= nil and v.animal ~= nil then
						if vehicle.animal == v.animal then
							-- vehicle:delete();
							g_currentMission:removeVehicle(vehicle);
							
							local silo = g_currentMission:getSiloAmount(Fillable.FILLTYPE_LIVESTOCK);
							g_currentMission:setSiloAmount(Fillable.FILLTYPE_LIVESTOCK, silo + 500)
							
							g_currentMission.missionStats.money = g_currentMission.missionStats.money + 1000;
							print("Livestock sold");	
						end;
					end;
				end;
			end;
		end;
	end;
end;

print("AnimalModTrigger V1.0 Loaded");