--
-- Alpenland 
-- 		by Lukas_96
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Alpenland = {}

local Alpenland_mt = Class(Alpenland, Mission00);

function Alpenland:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Alpenland_mt;
    end;
    local self = Alpenland:superClass():new(baseDirectory, mt);
    return self;
end;

function Alpenland:delete()
    Alpenland:superClass().delete(self);
end;

function Alpenland:load()
    self.environment = Environment:new(Utils.getFilename("AlpenChallenge/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("Alpenland.i3d", self.baseDirectory));
	
    -- load paths
    self:loadMap(Utils.getFilename("AlpenChallenge/paths/traffic.i3d", self.baseDirectory));

     -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("AlpenChallenge/pda_Alpen.png", self.baseDirectory));
            
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    
	Alpenland:superClass().load(self);
end
function Alpenland:loadFinished()
    Alpenland:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Alpenland:mouseEvent(posX, posY, isDown, isUp, button)
    Alpenland:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Alpenland:keyEvent(unicode, sym, modifier, isDown)
    Alpenland:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Alpenland:update(dt)
    Alpenland:superClass().update(self, dt);
end;

function Alpenland:draw()
    Alpenland:superClass().draw(self);
end;
