--
-- Manure Update
--
-- Author      - Koper
-- Date        - 21/04/2011
-- Patch v1.01 - 25/04/2011
-- Edit: Desperados93

FruitUtil.registerFruitType("manure2", false, false, true, 1, 100, 2, 1, 1, nil)
FruitUtil.registerFruitType("manure", false, false, true, 1, 100, 2, 1, 1, nil)

local sprayerUpdateTickBackup = Sprayer.updateTick
local sprayerLoadBackup = Sprayer.load

Sprayer.load = function(self, xmlFile)

	sprayerLoadBackup(self, xmlFile)

	if self.fillTypes[Fillable.FILLTYPE_MANURE] then

		self.manurev2active = true

	else

		self.manurev2active = false

	end;

end;

Sprayer.updateTick = function(self, dt)

	sprayerUpdateTickBackup(self, dt)

	if self.isTurnedOn then

		if self.fillLevel > 0 and self.manurev2active and self.currentFillType == Fillable.FILLTYPE_MANURE then

			for i = 1, table.getn(self.cuttingAreas) do

				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)

				local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE2, x, z, x1, z1, x2, z2);
				local value = 1+math.floor(old / total + 0.7);
				value = math.min(value, g_currentMission.maxWindrowValue);

					--[[print("I = " ..  i)
					print("rotation START = " .. math.deg(getWorldRotation(self.cuttingAreas[i].start)))
					print("rotation WIDTH = " .. math.deg(getWorldRotation(self.cuttingAreas[i].width)))
					print("rotation HEIGHT = " .. math.deg(getWorldRotation(self.cuttingAreas[i].height)))]]

				Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE2, x, z, x1, z1, x2, z2, value, true, false)

			end;

		end;

	end;

end;

local utilsCultivatorBackup = Utils.updateCultivatorArea
local utilsPloughBackup = Utils.updatePloughArea

Utils.updateCultivatorArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)

	utilsCultivatorBackup(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)

	Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE2, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, true, false)

end;

Utils.updatePloughArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)

	utilsPloughBackup(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)

	Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE2, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, true, false)

end;
