--
-- Alignment Aid
--
-- @author  	Christophe Calippe
-- @version 	v1.1
-- @date  		13/09/12
-- @history:	v1.0 - Initial version
--

--Description :
--
--This mod is an alignment aid vehicles.
--
--"Alignment aid" is version 1.1 of "Direction Helper"
--
--Function :
--
--It displays the path the vehicle will travel in a straight line.
--For this, it projects a red lazer on the front of the vehicle.
--
--Keys :
--
--The activation is done by using the CTRL key and the F12 key.
--
--Fix :
--
--Fixe the bug when closing the Map in version 1.0.
--
--Crédits
--
--This mod was made by myself.


--
-- AlignmentAid
--
AlignmentAid = {
    MAX_DISTANCE = 200,
    currentModName = g_currentModName,
    currentModDirectory = g_currentModDirectory,
    fichierTrace = getUserProfileAppPath() .. "trace.txt",
    isActive = nil
}


--
-- AlignmentAid.prerequisitesPresent
--
function AlignmentAid.prerequisitesPresent(specializations)
    return true;
end


--
-- AlignmentAid:loadMap
--
function AlignmentAid:loadMap(name)

    -- Only initialize once, and not at every .I3D file loaded.
    if (AlignmentAid.isActive == nil) then

        AlignmentAid.isActive = false

        tracer("loadMap")

        effacerTrace()
    end
end

;

--
-- AlignmentAid:deleteMap
--
function AlignmentAid:deleteMap()
end

--
--  AlignmentAid:mouseEvent
--
function AlignmentAid:mouseEvent(posX, posY, isDown, isUp, button)
end


--
-- AlignmentAid:keyEvent
--
function AlignmentAid:keyEvent(unicode, sym, modifier, isDown)

    --    tracer("keyEvent")

    if InputBinding.isPressed(InputBinding.TOGGLE_ALIGNMENT_AID) and InputBinding.isPressed(InputBinding.CONTROL_GAUCHE)
    then
        AlignmentAid.isActive = not AlignmentAid.isActive;
    end;
end


--
-- AlignmentAid:update
--
function AlignmentAid:update(dt)

    --    tracer("update")

    if AlignmentAid.isActive then

        BaseMission.AlignmentAiddt = dt;

        if g_currentMission.controlledVehicle ~= nil then

            local offset = 0.2;
            local r, g, b = 1, 0, 0;
            local longueurSegments = 20;

            local dirX, dirY, dirZ = localDirectionToWorld(g_currentMission.controlledVehicle.rootNode, 0, 0, 1);

            local lx1, ly1, lz1 = getWorldTranslation(g_currentMission.controlledVehicle.rootNode);

            ly1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx1, ly1, lz1) + offset;

            local lx2, ly2, lz2 = nil, nil, nil;

            for i = 0, math.floor(AlignmentAid.MAX_DISTANCE / longueurSegments) + 2 do
                lx2 = lx1 + (dirX * longueurSegments);
                ly2 = ly1 + (dirY * longueurSegments);
                lz2 = lz1 + (dirZ * longueurSegments);

                ly2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx2, ly2, lz2) + offset;

                drawDebugLine(lx1, ly1, lz1, r, g, b, lx2, ly2, lz2, r, g, b);

                lx1 = lx2;
                ly1 = ly2;
                lz1 = lz2;
            end;
        end;
    end;
end

function AlignmentAid:draw()

    --    tracer("draw")

    if g_currentMission.controlledVehicle ~= nil then

        if AlignmentAid.isActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("DESACTIVE_ALIGNMENT_AID"), InputBinding.TOGGLE_ALIGNMENT_AID);
        else
			g_currentMission:addHelpButtonText(g_i18n:getText("ACTIVE_ALIGNMENT_AID"), InputBinding.TOGGLE_ALIGNMENT_AID);
        end;

        
    end;
end

---
---- tracer
----
function tracer(message)

    if message == nil then
        message = "nil"
    end

    local fichier = io.open(AlignmentAid.fichierTrace, "a");

    if fichier ~= nil then
        fichier:write("[" .. AlignmentAid.currentModName .. "] " .. os.date("%H:%M:%S:") .. string.format("%f", os.clock()) .. ": " .. message .. "\n");
        fichier:flush();
        fichier:close();
    end;
end


---
---- effacerTrace
----
function effacerTrace()

    local fichier = io.open(AlignmentAid.fichierTrace, "w");
    fichier:close();
end

addModEventListener(AlignmentAid);