--
-- Feedo 80-13
-- author: Burner And Sanderbo
--

zamiatarka = {};

function zamiatarka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function zamiatarka:load(xmlFile)
	self.isTurnedOn = false;
	self.isLowered = false;  
    self.wasToFast = false;
	self.water = false;
	self.vijzel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vijzel#index"));
	self.band1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.band1#index"));
	self.band2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.band2#index"));
	self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
	self.soundTest = workSound;
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	self.waterParticle = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.water.water(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.waterParticle, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.waterParticle,false)
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;
end;

function zamiatarka:keyEvent(unicode, sym, modifier, isDown)
end;

function zamiatarka:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
           self.isLowered = not self.isLowered;
		end;
    end;
	Utils.setEmittingState(self.waterParticle, self.water);
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn then
	        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.water = not self.water;
			end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
	            playSample(self.workSound, 0, self.workSoundVolume, 0);
	            setSamplePitch(self.workSound, self.workSoundPitchOffset);
	            self.workSoundEnabled = true;
	        end;
			rotate(self.vijzel, dt*0.01, 0, 0 );
			rotate(self.band1, -dt*0.01, 0, 0 );
			rotate(self.band2, dt*0.01, 0, 0 );
			if self.isLowered then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 20;
				if not toFast then
					for fruitType,v in pairs(self.fruitTypes) do
						local area = 0;
						for k, cuttingArea in pairs(self.cuttingAreas) do
							local x,y,z = getWorldTranslation(cuttingArea.start);
							local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
							local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
						end;							
					end;
				end;
				self.wasToFast = toFast;
			end;
		else
			self.water = false;
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end;
    end;
end;

function zamiatarka:draw()
	if self.isTurnedOn then
		g_currentMission:addHelpButtonText("Turn Rollers off", InputBinding.IMPLEMENT_EXTRA);
    else
		g_currentMission:addHelpButtonText("Turn Rollers on", InputBinding.IMPLEMENT_EXTRA);
    end;
    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
    end;
 end; 
 
function zamiatarka:onLeave()
	self.water = false;
	self.isTurnedOn = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function zamiatarka:delete()
	self.water = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function zamiatarka:onDetach()
	self.water = false;
	self.isTurnedOn = false;
	self.isLowered = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function zamiatarka:onDeactivate()
	self.water = false;
    self.isTurnedOn = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function zamiatarka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zamiatarka:onEnter()
end;