--
-- PowershaftT
-- This is the specialization for PowershaftT
--
-- M@D Author  Headshot XXL
-- M@D date 08.08.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

PowershaftT = {};

function PowershaftT.prerequisitesPresent(specializations)
    return true;
end;

function PowershaftT:load(xmlFile)

	self.attacherJoints = {};

	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local object = Utils.indexToObject(self.components, index);
        if object ~= nil then
            local entry = {};
            entry.jointTransform = object;

            local jointTypeStr = getXMLString(xmlFile, baseName.. "#jointType");
            local jointType;
            if jointTypeStr ~= nil then
                jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
                if jointType == nil then
                    print("Warning: invalid jointType " .. jointTypeStr);
                end;
            end;
            if jointType == nil then
                jointType = Vehicle.JOINTTYPE_IMPLEMENT;
            end;
            entry.jointType = jointType;
            entry.allowsJointLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsJointLimitMovement"), true);
            entry.allowsLowering = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsLowering"), true);

            local x, y, z;
            local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#rotationNode"));
            if rotationNode ~= nil then
                entry.rotationNode = rotationNode;
                x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRot"));
                entry.maxRot = {};
                entry.maxRot[1] = math.rad(Utils.getNoNil(x, 0));
                entry.maxRot[2] = math.rad(Utils.getNoNil(y, 0));
                entry.maxRot[3] = math.rad(Utils.getNoNil(z, 0));

                x, y, z = getRotation(rotationNode);
                entry.minRot = {x,y,z};
            end;
            local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#rotationNode2"));
            if rotationNode2 ~= nil then
                entry.rotationNode2 = rotationNode2;
                x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRot2"));
                entry.maxRot2 = {};
                entry.maxRot2[1] = math.rad(Utils.getNoNil(x, 0));
                entry.maxRot2[2] = math.rad(Utils.getNoNil(y, 0));
                entry.maxRot2[3] = math.rad(Utils.getNoNil(z, 0));

                x, y, z = getRotation(rotationNode2);
                entry.minRot2 = {x,y,z};
            end;


            x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRotLimit"));
            entry.maxRotLimit = {};
            entry.maxRotLimit[1] = math.rad(math.abs(Utils.getNoNil(x, 0)));
            entry.maxRotLimit[2] = math.rad(math.abs(Utils.getNoNil(y, 0)));
            entry.maxRotLimit[3] = math.rad(math.abs(Utils.getNoNil(z, 0)));

            x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxTransLimit"));
            entry.maxTransLimit = {};
            entry.maxTransLimit[1] = math.abs(Utils.getNoNil(x, 0));
            entry.maxTransLimit[2] = math.abs(Utils.getNoNil(y, 0));
            entry.maxTransLimit[3] = math.abs(Utils.getNoNil(z, 0));

            entry.moveTime = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#moveTime"), 0.5)*1000;

            local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".topArm#rotationNode"));
            local translationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".topArm#translationNode"));
            local referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".topArm#referenceNode"));
            if rotationNode ~= nil then
                local topArm = {};
                topArm.rotationNode = rotationNode;
                topArm.rotX, topArm.rotY, topArm.rotZ = getRotation(rotationNode);
                if translationNode ~= nil and referenceNode ~= nil then
                    topArm.translationNode = translationNode;
                    local ax, ay, az = getWorldTranslation(referenceNode);
                    local bx, by, bz = getWorldTranslation(translationNode);
                    topArm.referenceDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
                end;
                topArm.zScale = Utils.sign(Utils.getNoNil(getXMLFloat(xmlFile, baseName.. ".topArm#zScale"), 1));
                entry.topArm = topArm;
            end;
            local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".bottomArm#rotationNode"));
            local translationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".bottomArm#translationNode"));
            local referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. ".bottomArm#referenceNode"));
            if rotationNode ~= nil then
                local bottomArm = {};
                bottomArm.rotationNode = rotationNode;
                bottomArm.rotX, bottomArm.rotY, bottomArm.rotZ = getRotation(rotationNode);
                if translationNode ~= nil and referenceNode ~= nil then
                    bottomArm.translationNode = translationNode;
                    local ax, ay, az = getWorldTranslation(referenceNode);
                    local bx, by, bz = getWorldTranslation(translationNode);
                    bottomArm.referenceDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
                end;
                bottomArm.zScale = Utils.sign(Utils.getNoNil(getXMLFloat(xmlFile, baseName.. ".bottomArm#zScale"), 1));
                entry.bottomArm = bottomArm;
            end;
            entry.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode")), self.components[1].node);
            entry.jointIndex = 0;
			
			local powershaftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#powershaftNode"));
			if powershaftNode ~= nil then
				entry.powerShaftAttacher = powershaftNode;
			end;
            table.insert(self.attacherJoints, entry);
        end;
        i = i+1;
    end;

    local i=0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local object = Utils.indexToObject(self.components, index);
        if object ~= nil then
            local entry = {};
            entry.jointTransform = object;
            entry.jointIndex = 0;
            local isLow = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#low"), false);

            if isLow then
                entry.jointType = Vehicle.JOINTTYPE_TRAILERLOW;
            else
                entry.jointType = Vehicle.JOINTTYPE_TRAILER;
            end;

            entry.allowsJointLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsJointLimitMovement"), false);
            entry.allowsLowering = false;

            local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRotLimit"));
            entry.maxRotLimit = {};
            entry.maxRotLimit[1] = Utils.degToRad(math.abs(Utils.getNoNil(x, 10)));
            entry.maxRotLimit[2] = Utils.degToRad(math.abs(Utils.getNoNil(y, 50)));
            entry.maxRotLimit[3] = Utils.degToRad(math.abs(Utils.getNoNil(z, 50)));

            x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxTransLimit"));
            entry.maxTransLimit = {};
            entry.maxTransLimit[1] = math.abs(Utils.getNoNil(x, 0));
            entry.maxTransLimit[2] = math.abs(Utils.getNoNil(y, 0));
            entry.maxTransLimit[3] = math.abs(Utils.getNoNil(z, 0));

            entry.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode")), self.components[1].node);

			local powershaftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#powershaftNode"));
			if powershaftNode ~= nil then
				entry.powerShaftAttacher = powershaftNode;
			end;
			
            table.insert(self.attacherJoints, entry);
        end;
        i = i+1;
    end;
	
end;

function PowershaftT:delete()
end;

function PowershaftT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowershaftT:keyEvent(unicode, sym, modifier, isDown)
end;

function PowershaftT:update(dt)
end;

function PowershaftT:draw()
end;
