--
-- AgromapRomania
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

AgromapRomania = {}

local AgromapRomania_mt = Class(AgromapRomania, Mission00);

function AgromapRomania:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = AgromapRomania_mt;
    end;
    local self = AgromapRomania:superClass():new(baseDirectory, mt);
    return self;
end;

function AgromapRomania:delete()
    AgromapRomania:superClass().delete(self);
end;

function AgromapRomania:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
        
    -- load NEW CowArea by Piki
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/M_CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    AgromapRomania:superClass().load(self);
end
function AgromapRomania:loadFinished()
    AgromapRomania:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function AgromapRomania:mouseEvent(posX, posY, isDown, isUp, button)
    AgromapRomania:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function AgromapRomania:keyEvent(unicode, sym, modifier, isDown)
    AgromapRomania:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function AgromapRomania:update(dt)
    AgromapRomania:superClass().update(self, dt);
end;

function AgromapRomania:draw()
    AgromapRomania:superClass().draw(self);
end;
