AgrolinerMUK402 = {};

function AgrolinerMUK402.prerequisitesPresent(specializations)
    return true;
end;

function AgrolinerMUK402:load(xmlFile)

	self.setTowballDirection = SpecializationUtil.callSpecializationsFunction("setTowballDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.attacherCylinder = {};
	self.attacherCylinder.leftCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinder"));
	self.attacherCylinder.leftPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderPunch"));
	self.attacherCylinder.leftFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderFixPoint"));
	if self.attacherCylinder.leftPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.leftFixPoint);
		self.attacherCylinder.leftDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.attacherCylinder.rightCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinder"));
	self.attacherCylinder.rightPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderPunch"));
	self.attacherCylinder.rightFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderFixPoint"));
	if self.attacherCylinder.rightPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.rightFixPoint);
		self.attacherCylinder.rightDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	
	self.grainAnimCurve = {};
	local keyI = 0;
	local keyII = 0;
	local keyIII = 0;
	while true do
		local key1 = string.format("vehicle.fillPlanes.fillPlane(%d)", keyI);
		local key2 = string.format("%s.node(%d)", key1, keyII);
		local key3 = string.format("%s.key(%d)", key2, keyIII);
		local node = getXMLString(xmlFile, key2.."#index");
		local planeType = getXMLString(xmlFile, key1.."#type");
		if planeType == nil and keyI > 0 then
			break;
		end;
		if node == nil then
			keyI = keyI + 1;
			keyII = -1;
		end;
		local t = Utils.getNoNil(getXMLFloat(xmlFile, key3.."#time"), -1);
		local yValue = getXMLFloat(xmlFile, key3.."#y");
		local scaleX, scaleY, scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key3.."#scale"));
		if t > -1 then
			if self.grainAnimCurve[planeType] == nil then
				self.grainAnimCurve[planeType] = AnimCurve:new(linearInterpolator4);
			end;
			self.grainAnimCurve[planeType]:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
		else
			keyII = keyII + 1;
			keyIII = -1;
		end;
		keyIII = keyIII + 1;
	end;
	
	self.fillPlaneAnim = AnimCurve:new(linearInterpolator4);
	self.fillPlaneAnim:addKeyframe({x=1, y=0.776, z=1, w=0, time = 0});
	self.fillPlaneAnim:addKeyframe({x=1, y=0.976, z=1, w=0, time = 1});

	self.fillPlaneDummy = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillPlaneTransform#index"));
	
	self.towBallAngle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallAngle#index"));
	
	self.wallsDown = true;
	self.wallsDownAllow = true;
	
	self.lowCapacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.capacity#low"), self.capacity);
	self.highCapacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.capacity#high"), self.capacity);
	self.capacity = self.highCapacity;
	self.fillLevelSet = false;

end;

function AgrolinerMUK402:delete()
end;

function AgrolinerMUK402:readStream(streamId, connection)	
end;

function AgrolinerMUK402:writeStream(streamId, connection)
end;

function AgrolinerMUK402:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AgrolinerMUK402:keyEvent(unicode, sym, modifier, isDown)
end;

function AgrolinerMUK402:update(dt)
	
	self.wallsDown = self.animationParts[1].clipStartTime and self.animationParts[1].inputDone;
	self:setTowballDirection();
	
	if self.fillLevel > self.lowCapacity then
		self.wallsDownAllow = false;
	elseif self.tipState == Trailer.TIPSTATE_CLOSED then
		self.wallsDownAllow = true;
	end;

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.wallsDown then
				self.fillLevelSet = false;
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			elseif self.wallsDownAllow then
				self.fillLevelSet = false;
				self:setAnimationTime(1, self.animationParts[1].offSet);
			end;
		end;
	end;
	
	local differenzScaleX, differenzScaleY, differenzScaleZ = getScale(self.fillPlaneDummy);
	if self.grainAnimCurve and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
		local fruitName = FruitUtil.fruitIndexToDesc[fruitType].name;
        local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve[fruitName]:get(self.fillLevel/self.capacity);
		local scaleX1, scaleY1, scaleZ1 , yTrans = self.grainAnimCurve[fruitName]:get(self.fillLevel/self.highCapacity);
		local differenz = scaleY1-scaleY;
		local fillLevel = math.max(self.fillLevel-self.lowCapacity, 0);
		local capacity = self.highCapacity-self.lowCapacity;
		local differenzScaleX, scaleY2, differenzScaleZ , yTrans2 = self.fillPlaneAnim:get(fillLevel/capacity);
		differenzScaleY = scaleY2+differenz;
	end;
	
	if self.animationParts[1].clipEndTime and self.animationParts[1].inputDone then
		self.capacity = self.highCapacity;
		if not self.fillLevelSet then
			self:setFillLevel(self.fillLevel, self.currentFillType);
			self.fillLevelSet = true;
		end;
		setScale(self.fillPlaneDummy, differenzScaleX, differenzScaleY+0.012, differenzScaleZ);
	elseif self.animationParts[1].clipStartTime and self.animationParts[1].inputDone then
		self.capacity = self.lowCapacity;
		if not self.fillLevelSet then
			self:setFillLevel(self.fillLevel, self.currentFillType);
			self.fillLevelSet = true;
		end;
		setScale(self.fillPlaneDummy, differenzScaleX, differenzScaleY, differenzScaleZ);
	end;
	
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punchDistance ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	end;
	
	if self.updateSteeringAxleAngle then
		if self.attacherVehicle ~= nil and self.movingDirection < 0 then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 + (self.lastSpeed*-3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;
		end;
	end;
	
end;

function AgrolinerMUK402:updateTick(dt)

	local steeringAxleAngle = 0;
	if self.attacherVehicle ~= nil then
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		steeringAxleAngle = -angle*0.75;
	end;
	setRotation(self.towBallAngle, 0, steeringAxleAngle, 0);
	
end;

function AgrolinerMUK402:setTowballDirection()
	if self.leftFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftCylinder);
		local bx, by, bz = getWorldTranslation(self.leftFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.leftCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.leftCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.leftDistance ~= nil then
			setTranslation(self.attacherCylinder.leftPunch, 0, 0, distance-self.attacherCylinder.leftDistance);
		end;
	end;
	if self.rightFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightCylinder);
		local bx, by, bz = getWorldTranslation(self.rightFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.rightCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.rightCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.rightDistance ~= nil then
			setTranslation(self.attacherCylinder.rightPunch, 0, 0, distance-self.attacherCylinder.rightDistance);
		end;
	end;
end;

function AgrolinerMUK402:draw()
	if self.wallsDown then
		g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerMUK402_1"), InputBinding.IMPLEMENT_EXTRA);
	elseif self.wallsDownAllow then
		g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerMUK402_2"), InputBinding.IMPLEMENT_EXTRA);
	end;
end;

function AgrolinerMUK402:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
end;

function AgrolinerMUK402:onDetach()
end;