--
-- Agrocom
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Agrocom = {}

local Agrocom_mt = Class(Agrocom, Mission00);

function Agrocom:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Agrocom_mt;
    end;
    local self = Agrocom:superClass():new(baseDirectory, mt);
    return self;
end;

function Agrocom:delete()
    Agrocom:superClass().delete(self);
end;

function Agrocom:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    --self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    --self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    Agrocom:superClass().load(self);
end
function Agrocom:loadFinished()
    Agrocom:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Agrocom:mouseEvent(posX, posY, isDown, isUp, button)
    Agrocom:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Agrocom:keyEvent(unicode, sym, modifier, isDown)
    Agrocom:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Agrocom:update(dt)
    Agrocom:superClass().update(self, dt);
end;

function Agrocom:draw()
    Agrocom:superClass().draw(self);
end;
