--
-- Triolet
-- Specialization for Triolet
--
-- @author Felix "Outlaw" Sorge
-- @date  27/04/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

Triolet = {};

function Triolet.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;


function Triolet:load(xmlFile)

	self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
	
	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {}
	self.collisionArm = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
	end; 	
		
	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.part" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
		for j=1, 3 do
			if part[i].rot[j] ~= 0 then
				part[i].rot[j] = 1/part[i].rot[j]
			end;
		end;
    end;
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste"; 
	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 	
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	self.AIon = false; 
	
	self.aiLeftMarker12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#LL"));
    self.aiRightMarker12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#RR"));
	self.saveAILM12 = self.aiLeftMarker12;
	self.saveAIRM12 = self.aiRightMarker12;
	
	self.aiLeftMarker6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#L"));
    self.aiRightMarker6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#R"));
	self.saveAILM6 = self.aiLeftMarker6;
	self.saveAIRM6 = self.aiRightMarker6;
	
	self.saveAILM = self.aiLeftMarker;
	self.saveAIRM = self.aiRightMarker;
	self.aiRightMarker = nil; 
	self.aiLeftMarker = nil; 
	self.change = 0; 
	self.dy = 6000; 
	
end;

function Triolet:keyEvent(unicode, sym, modifier, isDown)

	if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Triolet_ON) and self.AIon == false and self.fillLevel > 0 then
		self.turnOn = not self.turnOn; 
	end;
	
	if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Triolet_CHANGE) and self.AIon == false and self.fillLevel > 0 then
		self.change = self.change + 1;  
		if self.change == 3 then
			self.change = 0; 
		end; 	
	end;
	
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
	end;
end;




function Triolet:update(dt)

	if self.attacherVehicle then
		
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Taste"; 
		end; 
		
		if self.attacherVehicle.isAITractorActivated ~= nil  then
			self.AIon = self.attacherVehicle.isAITractorActivated;
		end; 	
		
		if self.AIon == false then
			self.AIblock = nil;
		end; 	
			
		if self.delay == true then
	        self.dy = self.dy - dt;
	        if self.dy <= 0 then
	            self.delay = false;
	            self.dy = 6000; 
				self.AIblock = nil; 
	        end;
	    end;
		
		if self.turnOn then				
					
			if self.attacherVehicle.isAITractorActivated ~= nil then
				if self.change == 0 then
					self.aiLeftMarker = self.saveAILM; 
					self.aiRightMarker = self.saveAIRM; 
				end; 
				if self.change == 1 then
					self.aiLeftMarker = self.saveAILM12; 
					self.aiRightMarker = self.saveAIRM12; 
				end; 
				if self.change == 2 then
					self.aiLeftMarker = self.saveAILM6; 
					self.aiRightMarker = self.saveAIRM6; 
				end; 
				AITractor.updateToolsInfo(self.attacherVehicle)
			end; 	
				
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, self.drums[i].rot[1] / 10 * dt, self.drums[i].rot[2] / 10 * dt, self.drums[i].rot[3] / 10 * dt);
			end;
			
			if self.fillLevel == 0 then
				self.turnOn = not self.turnOn;	
			end; 
			
			if self.AIon and self.AIblock == true then
				Utils.setEmittingState(self.dustParticleSystems, false)
			end; 
			if self.fillLevel > 0 and self.AIblock == nil then
			
				if self.deltaLevel == nil then
					self.deltaLevel = 1; 
				end; 
			
				
				if self.change == 0 then
				   	local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * 2.5; 
					self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
				
	                local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
	           end; 
			   
			   	if self.change == 1 then
				   	local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * 1.5; 
					self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
	                local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					local x,y,z = getWorldTranslation(self.cuttingAreas[4].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[4].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[4].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
	           end; 
			   
			   	if self.change == 2 then
					local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * 0.5; 
					self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
	                local x,y,z = getWorldTranslation(self.cuttingAreas[5].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[5].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[5].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					local x,y,z = getWorldTranslation(self.cuttingAreas[6].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[6].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[6].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
	           end; 
			   
			   
			
				Utils.setEmittingState(self.dustParticleSystems, true)
				
				
			end;
		else
			Utils.setEmittingState(self.dustParticleSystems, false)
			if self.attacherVehicle.isAITractorActivated ~= nil then
				self.aiLeftMarker = nil; 
				self.aiRightMarker = nil;
				AITractor.updateToolsInfo(self.attacherVehicle)
			end; 	
		end;
		
	end; 

	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false); 
	end; 
	
end;


function Triolet:draw()

	if self.AIon == false then
		if self.fillLevel > 0 then
			if self.turnOn then
				g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.Triolet_ON).. ": " ..g_i18n:getText("Triolet_2")); 
			else
				g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.Triolet_ON).. ": " ..g_i18n:getText("Triolet_1")); 
			end; 	
			
			if self.change == 0 then
				g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.Triolet_CHANGE).. ": " ..g_i18n:getText("Triolet_3").. " fast");
			end; 
			if self.change == 1 then
				g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.Triolet_CHANGE).. ": " ..g_i18n:getText("Triolet_3").. " medium");
			end
			if self.change == 2 then
				g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.Triolet_CHANGE).. ": " ..g_i18n:getText("Triolet_3").. " slow");
			end
		end; 
		
		if self.fillLevel == 0 then
			g_currentMission:addExtraPrintText(g_i18n:getText("Triolet_4"));
		end; 

	end;
	
end;


function Triolet:onAttach()
	self.Go.pillar = not self.Go.pillar; 
	self.Done.pillar = true; 
end; 	


function Triolet:onDetach()
	self.Go.pillar = not self.Go.pillar; 
	self.Done.pillar = true; 
	Utils.setEmittingState(self.dustParticleSystems, false)
end;


function Triolet:delete()
	removeJoint(self.collisionArm.pillar.index); 
	Utils.setEmittingState(self.dustParticleSystems, false)
	Utils.deleteParticleSystem(self.dustParticleSystems)
end;

function Triolet:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Triolet:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 


function Triolet:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;


function Triolet:aiLower()
	self.delay = true;
end; 


function Triolet:aiRaise()
	self.AIblock = true; 
end; 